/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.helper;

import com.aspose.words.BookmarksOutlineLevelCollection;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.SaveOptions;
import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.dto.HtmlHandleBaseDto;
import com.huawei.support.icscbb.convert.dto.HtmlHandlePdfDto;
import com.huawei.support.icscbb.convert.dto.HtmlSaveOptionsDto;
import com.huawei.support.icscbb.convert.thread.HtmlConvertThread;
import com.huawei.support.icscbb.convert.util.WordDocumentUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class HtmlConvertMainHelper {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HtmlConvertMainHelper.class);

    public static HtmlSaveOptionsDto getSaveOptions(HtmlConvertDto convertDto, DocumentBuilder builder, int saveFormatType) {
        String contentsName;
        String string = contentsName = StringUtils.equals((CharSequence)convertDto.getLang(), (CharSequence)"zh") ? "\u76ee\u5f55" : "Contents";
        if (saveFormatType == 10 || saveFormatType == 20) {
            return HtmlConvertMainHelper.getWordSaveOptionDto(saveFormatType, builder, contentsName);
        }
        if (saveFormatType == 40) {
            return HtmlConvertMainHelper.getPdfSaveOptionDto(builder, contentsName);
        }
        if (saveFormatType == 50) {
            return HtmlConvertMainHelper.getHtmlSaveOptionDto(saveFormatType, builder, contentsName);
        }
        return new HtmlSaveOptionsDto();
    }

    public static HtmlConvertThread getConvertThread(CountDownLatch countDownLatch, int saveFormatType, HtmlHandleBaseDto htmlHandleBaseDto, HtmlSaveOptionsDto saveOptionsDto) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Html convert get convert thread");
        if (saveFormatType == 10 || saveFormatType == 20 || saveFormatType == 50) {
            return new HtmlConvertThread(countDownLatch, htmlHandleBaseDto);
        }
        if (saveFormatType == 40) {
            HtmlHandlePdfDto handleHtmlPdfDto = new HtmlHandlePdfDto();
            BeanUtils.copyProperties((Object)htmlHandleBaseDto, (Object)handleHtmlPdfDto);
            handleHtmlPdfDto.setOutlineLevelCollection(saveOptionsDto.getOutlineLevels());
            return new HtmlConvertThread(countDownLatch, handleHtmlPdfDto);
        }
        return new HtmlConvertThread();
    }

    private static HtmlSaveOptionsDto getWordSaveOptionDto(int saveFormatType, DocumentBuilder builder, String contentsName) {
        SaveOptions saveOptions = saveFormatType == 20 ? SaveOptions.createSaveOptions((int)20) : new DocSaveOptions();
        saveOptions.setSaveFormat(saveFormatType);
        saveOptions.setMemoryOptimization(true);
        WordDocumentUtils.generateContents(builder, contentsName);
        HtmlSaveOptionsDto contentExdDto = new HtmlSaveOptionsDto();
        contentExdDto.setSaveOptions(saveOptions);
        return contentExdDto;
    }

    private static HtmlSaveOptionsDto getPdfSaveOptionDto(DocumentBuilder builder, String contentsName) {
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        pdfSaveOptions.setSaveFormat(40);
        pdfSaveOptions.setMemoryOptimization(true);
        BookmarksOutlineLevelCollection outlineLevels = WordDocumentUtils.generateContentsBookmark(builder, pdfSaveOptions, contentsName);
        HtmlSaveOptionsDto contentExdDto = new HtmlSaveOptionsDto();
        contentExdDto.setSaveOptions((SaveOptions)pdfSaveOptions);
        contentExdDto.setOutlineLevels(outlineLevels);
        return contentExdDto;
    }

    private static HtmlSaveOptionsDto getHtmlSaveOptionDto(int saveFormatType, DocumentBuilder builder, String contentsName) {
        HtmlSaveOptions saveOptions = new HtmlSaveOptions();
        saveOptions.setSaveFormat(saveFormatType);
        saveOptions.setExportOriginalUrlForLinkedImages(true);
        saveOptions.setMemoryOptimization(true);
        saveOptions.setUseHighQualityRendering(true);
        saveOptions.setUseAntiAliasing(true);
        saveOptions.setImageResolution(512);
        WordDocumentUtils.generateContents(builder, contentsName);
        HtmlSaveOptionsDto contentExdDto = new HtmlSaveOptionsDto();
        contentExdDto.setSaveOptions((SaveOptions)saveOptions);
        return contentExdDto;
    }
}

