/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.helper;

import com.huawei.support.icscbb.convert.dto.HtmlCreateDto;
import com.huawei.support.icscbb.convert.util.DocumentUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlSanitizeHelper {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HtmlSanitizeHelper.class);
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String HTML_LENGHT_UNIT_PX = "px";
    private static final int IMAGE_WIDTH_MAX = 523;
    private static final BigDecimal IMAGE_WIDTH_MAX_BIGDECIMAL = new BigDecimal("523");
    private static final int IMAGE_HEIGHT_MAX = 770;
    private static final BigDecimal IMAGE_HEIGHT_MAX_BIGDECIMAL = new BigDecimal("770");
    private static final BigDecimal IMAGE_OVERSIZE_RATE_TOP = new BigDecimal(8);
    private static final BigDecimal IMAGE_OVERSIZE_RATE_BOTTOM = new BigDecimal(10);
    private static final int DIVIDE_SCALE = 5;

    private HtmlSanitizeHelper() {
    }

    public static String sanitizeHtml(InputStream inputStream, HtmlCreateDto htmlCreateDto) throws IOException {
        Document document;
        if (inputStream == null) {
            return "";
        }
        try {
            document = Jsoup.parse((InputStream)inputStream, null, (String)"");
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to jsoup parse by inputStream.", (Throwable)e);
            return "";
        }
        return HtmlSanitizeHelper.processHtml(document, htmlCreateDto);
    }

    private static String processHtml(Document document, HtmlCreateDto htmlCreateDto) {
        if (document == null) {
            return "";
        }
        DocumentUtils.removeElementByTag(document, "h1");
        DocumentUtils.removeDoctypeNode(document);
        DocumentUtils.normalizeHtml(document);
        DocumentUtils.removeElementByTag(document, "div.footerNavBar.clearfix");
        DocumentUtils.dealWithA(document);
        DocumentUtils.dealWithSpanWithImg(document);
        HtmlSanitizeHelper.clearExtraClass(document);
        HtmlSanitizeHelper.doWithImgNode(document, htmlCreateDto.getZipFile(), htmlCreateDto.getTopicUrl(), htmlCreateDto.getImageFolder());
        DocumentUtils.copyOutCssToHtml(document, htmlCreateDto.getCssContent());
        DocumentUtils.removeElementByTag(document, "link[href]");
        DocumentUtils.removeScriptTag(document);
        DocumentUtils.replaceHeadingTags(document);
        return document.toString();
    }

    private static void clearExtraClass(Document document) {
        DocumentUtils.removeElementByClass(document, "hrcopyright");
        DocumentUtils.removeElementByClass(document, "colHidden");
        DocumentUtils.removeElementByClass(document, "topNavBar");
        DocumentUtils.removeElementByClass(document, "hwcopyright");
        DocumentUtils.removeElementByClass(document, "familylinks");
        DocumentUtils.removeElementByClass(document, "parentlink");
        DocumentUtils.removeElementByClass(document, "relref");
        DocumentUtils.removeElementByClass(document, "reltasks");
        DocumentUtils.removeElementByClass(document, "relconcepts");
    }

    private static void doWithImgNode(Document document, ZipFile zipFile, String topicUrl, String imageFolder) {
        Elements imgElements = document.select("img[src]");
        for (Element element : imgElements) {
            String imgSrc = DocumentUtils.getRelativeUrl(topicUrl, element.attr("src"));
            ZipArchiveEntry zipArchiveEntry = zipFile.getEntry(imgSrc);
            if (zipArchiveEntry != null) {
                HtmlSanitizeHelper.handleImgInputStream(element, zipFile, zipArchiveEntry, imgSrc, imageFolder);
                continue;
            }
            zipArchiveEntry = zipFile.getEntry(imgSrc.toLowerCase(Locale.ROOT));
            if (zipArchiveEntry == null) continue;
            HtmlSanitizeHelper.handleImgInputStream(element, zipFile, zipArchiveEntry, imgSrc, imageFolder);
        }
    }

    private static void handleImgInputStream(Element element, ZipFile zipFile, ZipArchiveEntry zipArchiveEntry, String imgSrc, String imageFolder) {
        try (InputStream imgInputStream = zipFile.getInputStream(zipArchiveEntry);){
            if (imgInputStream == null) {
                return;
            }
            int dotIndex = imgSrc.lastIndexOf(".");
            String suffix = imgSrc.substring(dotIndex);
            String newImgPrefix = imageFolder + File.separator + UUID.randomUUID();
            if (StringUtils.equals((CharSequence)suffix, (CharSequence)".png")) {
                newImgPrefix = newImgPrefix + ".jpg";
                HtmlSanitizeHelper.pngToJpg(imgInputStream, newImgPrefix);
            } else {
                newImgPrefix = newImgPrefix + suffix;
                FileUtils.copyInputStreamToFile((InputStream)imgInputStream, (File)FileUtils.getFile((String[])new String[]{newImgPrefix}));
            }
            element.attr("src", newImgPrefix);
            BufferedImage bufferedImage = ImageIO.read(FileUtils.getFile((String[])new String[]{newImgPrefix}));
            if (bufferedImage == null) {
                return;
            }
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            while (width > 523 || height > 770) {
                width = new BigDecimal(width).multiply(IMAGE_OVERSIZE_RATE_TOP).divide(IMAGE_OVERSIZE_RATE_BOTTOM, 5, RoundingMode.UP).intValue();
                height = new BigDecimal(height).multiply(IMAGE_OVERSIZE_RATE_TOP).divide(IMAGE_OVERSIZE_RATE_BOTTOM, 5, RoundingMode.UP).intValue();
            }
            String widthAttr = element.attr(ATTRIBUTE_WIDTH);
            String heightAttr = element.attr(ATTRIBUTE_HEIGHT);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "widthAttr is {0}, heightAttr is {1}.", new Object[]{widthAttr, heightAttr});
            HtmlSanitizeHelper.setImageHeightAndWidth(element, heightAttr, height, widthAttr, width);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IOException occurred while getting image inputStream from zipFile.", (Throwable)e);
        }
    }

    private static void pngToJpg(InputStream pngInputStream, String jpgImgSrc) {
        try {
            BufferedImage pngBufferedImage = ImageIO.read(pngInputStream);
            if (pngBufferedImage == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Png image read failed.");
                return;
            }
            BufferedImage jpgBufferedImage = new BufferedImage(pngBufferedImage.getWidth(), pngBufferedImage.getHeight(), 1);
            jpgBufferedImage.createGraphics().drawImage(pngBufferedImage, 0, 0, Color.WHITE, null);
            ImageIO.write((RenderedImage)jpgBufferedImage, "jpg", FileUtils.getFile((String[])new String[]{jpgImgSrc}));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Read Png image stream failed.", (Throwable)e);
        }
    }

    private static void setImageHeightAndWidth(Element element, String heightAttr, int height, String widthAttr, int width) {
        if (StringUtils.isBlank((CharSequence)heightAttr) && StringUtils.isBlank((CharSequence)widthAttr)) {
            element.attr(ATTRIBUTE_WIDTH, width + HTML_LENGHT_UNIT_PX);
            element.attr(ATTRIBUTE_HEIGHT, height + HTML_LENGHT_UNIT_PX);
            return;
        }
        BigDecimal heightAttrValue = StringUtils.isBlank((CharSequence)heightAttr) ? new BigDecimal("0") : HtmlSanitizeHelper.getBigDecimalFromString(heightAttr);
        BigDecimal widthAttrValue = StringUtils.isBlank((CharSequence)widthAttr) ? new BigDecimal("0") : HtmlSanitizeHelper.getBigDecimalFromString(widthAttr);
        if (IMAGE_HEIGHT_MAX_BIGDECIMAL.compareTo(heightAttrValue) < 0 || IMAGE_WIDTH_MAX_BIGDECIMAL.compareTo(widthAttrValue) < 0) {
            element.attr(ATTRIBUTE_WIDTH, width + HTML_LENGHT_UNIT_PX);
            element.attr(ATTRIBUTE_HEIGHT, height + HTML_LENGHT_UNIT_PX);
        }
    }

    private static BigDecimal getBigDecimalFromString(String numStr) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(numStr);
        }
        catch (NumberFormatException e) {
            bigDecimal = new BigDecimal("1000");
        }
        return bigDecimal;
    }
}

