/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.helper;

import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.huawei.support.icscbb.convert.builder.ParagraphBuilder;
import com.huawei.support.icscbb.convert.constant.StatementConstants;
import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.dto.ParagraphDto;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class StatementHelper {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(StatementHelper.class);
    private static final Map<String, String> STATEMENT_PATH_MAP = new HashMap<String, String>();

    private StatementHelper() {
    }

    public static Optional<Document> generateCoverAndStatement(HtmlConvertDto htmlConvertDto) throws Exception {
        Properties statementProp = StatementHelper.getStatementProperties(htmlConvertDto.getLang());
        if (statementProp.isEmpty()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Statement properties file is empty.");
            return Optional.empty();
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Generate cover page and statement page starts.");
        Document doc = new Document();
        DocumentBuilder documentBuilder = new DocumentBuilder(doc);
        StatementHelper.setPageLayout(documentBuilder);
        ParagraphBuilder paragraphBuilder = new ParagraphBuilder(documentBuilder);
        StatementHelper.addCoverPage(paragraphBuilder, htmlConvertDto, statementProp);
        documentBuilder.insertBreak(5);
        documentBuilder.getCurrentSection().getPageSetup().clearFormatting();
        StatementHelper.setPageLayout(documentBuilder);
        documentBuilder.getCurrentSection().getPageSetup().setSectionStart(2);
        documentBuilder.getCurrentSection().getPageSetup().setRestartPageNumbering(true);
        documentBuilder.getCurrentSection().getPageSetup().setPageStartingNumber(0);
        StatementHelper.addStatementPage(paragraphBuilder, htmlConvertDto, statementProp);
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Generate cover page and statement page success.");
        return Optional.ofNullable(doc);
    }

    private static Properties getStatementProperties(String lang) {
        Properties prop = new Properties();
        String propPath = STATEMENT_PATH_MAP.get(lang);
        ClassPathResource classPathResource = new ClassPathResource(propPath);
        try (InputStream in = classPathResource.getInputStream();
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            prop.load(reader);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Load statement properties file failed.", (Throwable)e);
        }
        return prop;
    }

    private static void addCoverPage(ParagraphBuilder paragraphBuilder, HtmlConvertDto htmlConvertDto, Properties statementProp) {
        paragraphBuilder.insertTextParagraph(new ParagraphDto().setText(htmlConvertDto.getProductName()).setLeftIndent(20.0).setSpaceBefore(90.0).setLineSpacing(12.0).setFontSize(20.0).setBold(true));
        paragraphBuilder.insertTextParagraph(new ParagraphDto().setText(htmlConvertDto.getProductVersion()).setLeftIndent(20.0).setLineSpacing(10.0).setFontSize(20.0).setBold(true));
        paragraphBuilder.insertTextParagraph(new ParagraphDto().setText(htmlConvertDto.getFileName()).setLeftIndent(20.0).setSpaceBefore(5.0).setLineSpacing(12.0).setFontSize(25.0).setBold(true));
        paragraphBuilder.insertTextParagraph(new ParagraphDto().setText(htmlConvertDto.getIssueDate()).setLeftIndent(20.0).setSpaceBefore(60.0).setLineSpacing(12.0).setFontSize(12.0).setBold(true));
        InputStream earthImageIs = StatementHelper.class.getClassLoader().getResourceAsStream("cover.png");
        paragraphBuilder.insertImage(earthImageIs, -40.0, 350.0, 595.0, 268.2);
        InputStream hwLogoImageIs = StatementHelper.class.getClassLoader().getResourceAsStream("hwlogo.png");
        paragraphBuilder.insertImage(hwLogoImageIs, 380.0, 700.0, 70.0, 71.32);
        paragraphBuilder.writeCompany((String)StringUtils.defaultIfBlank((CharSequence)htmlConvertDto.getCoverCompanyName(), (CharSequence)statementProp.getProperty("cover.company")));
    }

    private static void addStatementPage(ParagraphBuilder paragraphBuilder, HtmlConvertDto htmlConvertDto, Properties statementProp) {
        if (StringUtils.equals((CharSequence)htmlConvertDto.getTaskType(), (CharSequence)"pid")) {
            StatementHelper.addPidStatements(paragraphBuilder, htmlConvertDto, statementProp);
        } else if (StringUtils.equals((CharSequence)htmlConvertDto.getTaskType(), (CharSequence)"customize")) {
            StatementHelper.addCustomizationStatements(paragraphBuilder, htmlConvertDto, statementProp);
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Unsupported task type.");
        }
    }

    private static void addPidStatements(ParagraphBuilder paragraphBuilder, HtmlConvertDto htmlConvertDto, Properties statementProp) {
        String currentYear = new SimpleDateFormat("yyyy").format(new Date());
        String copyrightStatementTitle = statementProp.getProperty("copyright.statement.title.p1") + currentYear + statementProp.getProperty("copyright.statement.title.p2");
        paragraphBuilder.insertLeftAlignedTitle(copyrightStatementTitle);
        paragraphBuilder.insertContent(statementProp.getProperty("copyright.statement.content"));
        paragraphBuilder.insertLeftAlignedTitle(statementProp.getProperty("trademark.statement.title"));
        ParagraphDto trademarkContentPara = new ParagraphDto().setText(" " + statementProp.getProperty("trademark.statement.content.p1")).setLeftIndent(5.0).setSpaceBefore(20.0).setLineSpacing(10.0).setFontSize(10.0);
        InputStream hwLogoImageIs = StatementHelper.class.getClassLoader().getResourceAsStream("hwlogo.png");
        paragraphBuilder.insertImageParagraph(trademarkContentPara, hwLogoImageIs, 30.0);
        paragraphBuilder.insertContent(statementProp.getProperty("trademark.statement.content.p2"));
        paragraphBuilder.insertLeftAlignedTitle(statementProp.getProperty("notice.statement.title"));
        paragraphBuilder.insertContent(statementProp.getProperty("notice.statement.content.p1"));
        paragraphBuilder.insertBlankParagraph(8.0);
        paragraphBuilder.insertContent(statementProp.getProperty("notice.statement.content.p2"));
        paragraphBuilder.insertTextParagraph(new ParagraphDto().setText(statementProp.getProperty("company")).setLeftIndent(5.0).setSpaceBefore(60.0).setSpaceAfter(15.0).setLineSpacing(12.0).setFontSize(15.0).setBold(true));
        paragraphBuilder.insertContent(statementProp.getProperty("address"));
        String addressDetail = statementProp.getProperty("address.detail");
        if (StringUtils.isNotBlank((CharSequence)addressDetail)) {
            String[] addressParts;
            for (String addressPart : addressParts = StringUtils.split((String)addressDetail, (String)";")) {
                paragraphBuilder.insertContent("                  " + addressPart);
            }
        }
        paragraphBuilder.insertBlankParagraph(8.0);
        paragraphBuilder.insertContent(statementProp.getProperty("website"));
        paragraphBuilder.insertHyperLink(htmlConvertDto.getHuaweiWebsite(), htmlConvertDto.getHuaweiWebsite());
        paragraphBuilder.insertBlankParagraph(8.0);
        paragraphBuilder.insertContent(statementProp.getProperty("email"));
        paragraphBuilder.insertHyperLink("support@huawei.com", htmlConvertDto.getHuaweiMail());
        String hotline = statementProp.getProperty("hotline");
        if (StringUtils.isNotBlank((CharSequence)hotline)) {
            paragraphBuilder.insertBlankParagraph(8.0);
            paragraphBuilder.insertContent(statementProp.getProperty("hotline"));
        }
    }

    private static void addCustomizationStatements(ParagraphBuilder paragraphBuilder, HtmlConvertDto htmlConvertDto, Properties statementProp) {
        paragraphBuilder.insertCenterTitle(statementProp.getProperty("disclaimer"));
        if (StringUtils.isBlank((CharSequence)htmlConvertDto.getDisclaimer())) {
            paragraphBuilder.insertContent(statementProp.getProperty("disclaimer.content.p1"));
            paragraphBuilder.insertContent(statementProp.getProperty("disclaimer.content.p2"));
            return;
        }
        Arrays.stream(htmlConvertDto.getDisclaimer().split(String.valueOf('\n'))).forEach(paragraphBuilder::insertContent);
    }

    private static void setPageLayout(DocumentBuilder builder) {
        if (builder == null) {
            return;
        }
        builder.getCurrentSection().getPageSetup().setPageWidth(595.0);
        builder.getCurrentSection().getPageSetup().setPageHeight(842.0);
        builder.getCurrentSection().getPageSetup().setTopMargin(0.0);
        builder.getCurrentSection().getPageSetup().setBottomMargin(0.0);
        builder.getCurrentSection().getPageSetup().setLeftMargin(40.0);
        builder.getCurrentSection().getPageSetup().setRightMargin(40.0);
    }

    static {
        STATEMENT_PATH_MAP.put("zh", StatementConstants.STATEMENT_FILE_PATH_ZH);
        STATEMENT_PATH_MAP.put("en", StatementConstants.STATEMENT_FILE_PATH_EN);
    }
}

