/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.thread;

import com.huawei.support.icscbb.convert.dto.HtmlHandleBaseDto;
import com.huawei.support.icscbb.convert.helper.HtmlConvertHelper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.concurrent.CountDownLatch;

public class HtmlConvertThread
implements Runnable {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HtmlConvertThread.class);
    private CountDownLatch countDownLatch;
    private HtmlHandleBaseDto handleHtmlDto;

    @Override
    public void run() {
        if (this.handleHtmlDto == null || this.countDownLatch == null) {
            return;
        }
        try {
            HtmlConvertHelper.handleHtmlListMain(this.handleHtmlDto);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "HtmlConvertThread failed to convert html list.", (Throwable)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public HtmlHandleBaseDto getHandleHtmlDto() {
        return this.handleHtmlDto;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void setHandleHtmlDto(HtmlHandleBaseDto handleHtmlDto) {
        this.handleHtmlDto = handleHtmlDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HtmlConvertThread)) {
            return false;
        }
        HtmlConvertThread other = (HtmlConvertThread)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CountDownLatch this$countDownLatch = this.getCountDownLatch();
        CountDownLatch other$countDownLatch = other.getCountDownLatch();
        if (this$countDownLatch == null ? other$countDownLatch != null : !this$countDownLatch.equals(other$countDownLatch)) {
            return false;
        }
        HtmlHandleBaseDto this$handleHtmlDto = this.getHandleHtmlDto();
        HtmlHandleBaseDto other$handleHtmlDto = other.getHandleHtmlDto();
        return !(this$handleHtmlDto == null ? other$handleHtmlDto != null : !this$handleHtmlDto.equals(other$handleHtmlDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HtmlConvertThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CountDownLatch $countDownLatch = this.getCountDownLatch();
        result = result * 59 + ($countDownLatch == null ? 43 : $countDownLatch.hashCode());
        HtmlHandleBaseDto $handleHtmlDto = this.getHandleHtmlDto();
        result = result * 59 + ($handleHtmlDto == null ? 43 : $handleHtmlDto.hashCode());
        return result;
    }

    public String toString() {
        return "HtmlConvertThread(countDownLatch=" + this.getCountDownLatch() + ", handleHtmlDto=" + this.getHandleHtmlDto() + ")";
    }

    public HtmlConvertThread() {
    }

    public HtmlConvertThread(CountDownLatch countDownLatch, HtmlHandleBaseDto handleHtmlDto) {
        this.countDownLatch = countDownLatch;
        this.handleHtmlDto = handleHtmlDto;
    }
}

