/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class AsposeInitUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(AsposeInitUtils.class);

    private AsposeInitUtils() {
    }

    public static String getFontsPath() {
        URL fontsUrl = AsposeInitUtils.class.getClassLoader().getResource("fonts");
        return fontsUrl == null ? "" : fontsUrl.getPath();
    }

    public static String getTmpConvertPath() {
        URL tmpUrl = AsposeInitUtils.class.getClassLoader().getResource("temp");
        return tmpUrl == null ? "" : tmpUrl.getPath();
    }

    public static String getLicenseContent(String signature) {
        String content = "";
        try (InputStream in = AsposeInitUtils.class.getClassLoader().getResourceAsStream("Aspose.Total.Java.lic");
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            content = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
            content = content.replace("<Signature></Signature>", signature);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Load Aspose License error.", (Throwable)e);
        }
        return content;
    }
}

