/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.util;

import com.huawei.support.icscbb.convert.constant.ConvertConstants;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class DocumentUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DocumentUtils.class);
    private static final String LINK_LABEL_POINTER = "href";
    private static final String DIV_LABEL_NAME = "div";
    private static final String HREF_ICS_SEARCH_PREFIX_NAME = "icssearchname";
    private static final String HREF_CMD_QUERY_PREFIX_NAME = "cmdqueryname";
    private static final List<String> HEADING_TAG_LIST = Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6");

    private DocumentUtils() {
    }

    public static void dealWithA(Document document) {
        if (document == null) {
            return;
        }
        Elements linkLabels = document.select("a[href]");
        if (CollectionUtils.isEmpty((Collection)linkLabels)) {
            return;
        }
        for (Element linkLabel : linkLabels) {
            String href = linkLabel.attr(LINK_LABEL_POINTER);
            if (StringUtils.startsWithAny((CharSequence)href, (CharSequence[])new CharSequence[]{HREF_ICS_SEARCH_PREFIX_NAME, HREF_CMD_QUERY_PREFIX_NAME})) {
                linkLabel.attr(LINK_LABEL_POINTER, "####");
                linkLabel.tagName("span");
            }
            if (!DocumentUtils.isOuterResource(href)) continue;
            linkLabel.attr(LINK_LABEL_POINTER, "####");
            linkLabel.tagName("custom_hyperlink");
        }
    }

    public static void dealWithSpanWithImg(Document document) {
        if (document == null) {
            return;
        }
        Elements imgLabels = document.select("span img");
        if (CollectionUtils.isEmpty((Collection)imgLabels)) {
            return;
        }
        for (Element imgLabel : imgLabels) {
            Element brElement;
            Element parentElement = imgLabel.parent();
            if (parentElement == null || parentElement.previousSibling() == null || !(parentElement.previousSibling() instanceof Element) || !StringUtils.equalsIgnoreCase((CharSequence)(brElement = (Element)parentElement.previousSibling()).tagName(), (CharSequence)"br")) continue;
            brElement.tagName(DIV_LABEL_NAME);
        }
    }

    private static boolean isOuterResource(String href) {
        return ConvertConstants.EXTERNAL_RESOURCES_SUFFIX_LIST.stream().anyMatch(suffix -> StringUtils.contains((CharSequence)href, (CharSequence)suffix));
    }

    public static void normalizeHtml(Document document) {
        if (document == null) {
            return;
        }
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
    }

    public static void removeDoctypeNode(Document document) {
        if (document == null) {
            return;
        }
        List nodes = document.childNodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return;
        }
        for (Node node : nodes) {
            if (!StringUtils.equals((CharSequence)node.nodeName(), (CharSequence)"#doctype")) continue;
            node.remove();
            break;
        }
    }

    public static void removeElementByClass(Document document, String className) {
        if (document == null || StringUtils.isBlank((CharSequence)className)) {
            return;
        }
        Elements elementsByClass = document.getElementsByClass(className);
        if (CollectionUtils.isNotEmpty((Collection)elementsByClass)) {
            elementsByClass.remove();
        }
    }

    public static void removeElementByTag(Document document, String tagName) {
        if (document == null || StringUtils.isBlank((CharSequence)tagName)) {
            return;
        }
        Elements elementsByTag = document.select(tagName);
        if (CollectionUtils.isNotEmpty((Collection)elementsByTag)) {
            elementsByTag.remove();
        }
    }

    public static void removeScriptTag(Document document) {
        if (document == null) {
            return;
        }
        Elements scripts = document.getElementsByTag("script");
        if (CollectionUtils.isNotEmpty((Collection)scripts)) {
            scripts.remove();
        }
    }

    public static void replaceHeadingTags(Document document) {
        if (document == null) {
            return;
        }
        for (String htag : HEADING_TAG_LIST) {
            Elements elementsByTag = document.getElementsByTag(htag);
            if (elementsByTag == null) continue;
            elementsByTag.tagName(DIV_LABEL_NAME);
        }
    }

    public static void copyOutCssToHtml(Document document, String cssContent) {
        if (document == null || StringUtils.isBlank((CharSequence)cssContent)) {
            return;
        }
        Elements headElements = document.getElementsByTag("head");
        if (CollectionUtils.isNotEmpty((Collection)headElements)) {
            Element styleElement = ((Element)headElements.get(0)).appendElement("style");
            styleElement.attr("type", "text/css");
            styleElement.appendText(cssContent);
        }
    }

    public static String getRelativeUrl(String topicUrl, String imgRelativePath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{topicUrl, imgRelativePath})) {
            return "";
        }
        String normalTopicUrl = "http://" + topicUrl.replace("\\", "/");
        String relativeUrl = "";
        try {
            URL topicPathUrl = new URL(normalTopicUrl);
            URL parseUrl = new URL(topicPathUrl, imgRelativePath);
            relativeUrl = parseUrl.toString();
            relativeUrl = relativeUrl.replaceFirst("http://", "");
        }
        catch (MalformedURLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get image relative path failed.", (Throwable)e);
        }
        return relativeUrl;
    }
}

