/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ProgressPropertyUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ProgressPropertyUtils.class);

    private ProgressPropertyUtils() {
    }

    public static synchronized boolean updateFinishedNum(String propertyFileName) {
        String currentFinishedNumStr = ProgressPropertyUtils.getConvertProgressByProperty(propertyFileName, "finishNum");
        if (StringUtils.isBlank((CharSequence)currentFinishedNumStr)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Before update,the finish num is blank,the value is {0}.", new Object[]{currentFinishedNumStr});
            return false;
        }
        int currentFinishedNum = Integer.parseInt(currentFinishedNumStr);
        return ProgressPropertyUtils.updateConvertProgressProperty(propertyFileName, "finishNum", currentFinishedNum + 1 + "");
    }

    public static synchronized String getConvertProgressByProperty(String propertyFileName, String keyName) {
        return PropertiesUtils.getPropertyValue((String)propertyFileName, (String)keyName);
    }

    public static synchronized boolean updateConvertProgressProperty(String propertyFileName, String keyName, String value) {
        Optional progressPropertyOptional = PropertiesUtils.getPropertiesByFileName((String)propertyFileName);
        if (!progressPropertyOptional.isPresent()) {
            return false;
        }
        Properties progressProperty = (Properties)progressPropertyOptional.get();
        progressProperty.setProperty(keyName, value);
        return PropertiesUtils.storeProperties((Properties)progressProperty, (String)propertyFileName);
    }

    public static boolean initConvertProgressProperty(String propertyName, String docNum) {
        try {
            File progressFile = FileUtils.getFile((String[])new String[]{propertyName});
            FileUtils.deleteQuietly((File)progressFile);
            File parentFile = progressFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "The convert progress file parent directory not exists and create failed.");
                return false;
            }
            if (!progressFile.createNewFile()) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "The convert progress file create failed.");
                return false;
            }
            boolean updateTotalNum = ProgressPropertyUtils.updateConvertProgressProperty(propertyName, "totalNum", (String)StringUtils.defaultIfBlank((CharSequence)docNum, (CharSequence)"0"));
            boolean updateFinishNum = ProgressPropertyUtils.updateConvertProgressProperty(propertyName, "finishNum", "0");
            return updateTotalNum && updateFinishNum;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The convert progress file create failed.", (Throwable)e);
            return true;
        }
    }
}

