/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class ResourceFileUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ResourceFileUtils.class);

    private ResourceFileUtils() {
    }

    public static String getFileContent(String fileInPath) {
        if (StringUtils.isBlank((CharSequence)fileInPath)) {
            return "";
        }
        ClassPathResource classPathResource = new ClassPathResource(fileInPath);
        StringBuilder resultBuilder = new StringBuilder();
        try (InputStream inputStream = classPathResource.getInputStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                resultBuilder.append(line);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Read resources file failed.", (Throwable)e);
        }
        return resultBuilder.toString();
    }
}

