/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.convert.util;

import com.aspose.words.BookmarksOutlineLevelCollection;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.ImageData;
import com.aspose.words.LayoutCollector;
import com.aspose.words.LayoutEnumerator;
import com.aspose.words.List;
import com.aspose.words.ListLevel;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Run;
import com.aspose.words.Shape;
import com.aspose.words.StyleCollection;
import com.aspose.words.Table;
import com.huawei.support.icscbb.convert.dto.HtmlDocumentDto;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class WordDocumentUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(WordDocumentUtils.class);
    private static final double DOCUMENT_PAGE_WIDTH = 595.0;
    private static final double DOCUMENT_PAGE_HEIGHT = 842.0;
    private static final double DOCUMENT_TOP_MARGIN = 36.0;
    private static final double DOCUMENT_BOTTOM_MARGIN = 36.0;
    private static final double DOCUMENT_LEFT_MARGIN = 40.0;
    private static final double DOCUMENT_RIGHT_MARGIN = 40.0;
    private static final double HEADER_FONT_SIZE = 10.0;
    private static final double FOOTER_LINE_WIDTH = 0.25;
    private static final double HEADER_FOOTER_FONT_SIZE = 7.5;
    private static final double FOOTER_PADDING = 0.0;
    private static final double HEADER_FOOTER_DISTANCE = 2.0;
    private static final int DIVIDE_SCALE = 5;
    private static final BigDecimal IMAGE_RESIZE_RATIO = new BigDecimal("0.8");
    private static final String SYMBOL_FONT_NAME = "Symbol";
    private static final String UNICODE_CHARACTER_SQUARE = "\uf0b7";
    private static final String UNICODE_CHARACTER_BULLET = "\u2022";
    private static final String RULE_OF_INSERT_CONTENTS = "\\o\"1-9\"\\h\\z\\u";

    private WordDocumentUtils() {
    }

    public static void setHeadingStyle(Document document) {
        if (document == null) {
            return;
        }
        StyleCollection styles = document.getStyles();
        styles.getByStyleIdentifier(2).getFont().setItalic(false);
        styles.getByStyleIdentifier(5).getFont().setItalic(false);
        styles.getByStyleIdentifier(8).getFont().setItalic(false);
    }

    public static void generateContents(DocumentBuilder builder, String contentsName) {
        if (builder == null) {
            return;
        }
        WordDocumentUtils.contentsCommonOperate(builder);
        builder.writeln(contentsName);
        builder.getParagraphFormat().clearFormatting();
        builder.insertTableOfContents(RULE_OF_INSERT_CONTENTS);
    }

    public static BookmarksOutlineLevelCollection generateContentsBookmark(DocumentBuilder builder, PdfSaveOptions pdfSaveOptions, String contentsName) {
        if (builder == null) {
            return new BookmarksOutlineLevelCollection();
        }
        WordDocumentUtils.contentsCommonOperate(builder);
        builder.startBookmark(contentsName);
        builder.writeln(contentsName);
        builder.endBookmark(contentsName);
        builder.getParagraphFormat().clearFormatting();
        BookmarksOutlineLevelCollection outlineLevels = pdfSaveOptions.getOutlineOptions().getBookmarksOutlineLevels();
        outlineLevels.add(contentsName, 1);
        builder.insertTableOfContents(RULE_OF_INSERT_CONTENTS);
        return outlineLevels;
    }

    private static void contentsCommonOperate(DocumentBuilder builder) {
        if (builder == null) {
            return;
        }
        builder.moveToDocumentStart();
        builder.getCurrentParagraph().getParagraphFormat().setAlignment(1);
        builder.getParagraphFormat().setStyleIdentifier(1);
    }

    public static void insertDocument(DocumentBuilder builder, HtmlDocumentDto htmlDocumentDto, int headingLevel, String tempHtml) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Word insert tempHtml to document.");
        if (builder == null) {
            return;
        }
        builder.getParagraphFormat().setStyleIdentifier(headingLevel);
        WordDocumentUtils.setTitleFont(builder.getParagraphFormat(), StringUtils.isBlank((CharSequence)htmlDocumentDto.getDocRelativeName()));
        builder.writeln(htmlDocumentDto.getNaviPosition() + " " + htmlDocumentDto.getDocTitleName());
        try {
            builder.insertHtml(tempHtml);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Word insert tempHtml to document error.", (Throwable)e);
        }
    }

    public static void insertDocumentWithBookmark(DocumentBuilder builder, BookmarksOutlineLevelCollection outlineLevels, HtmlDocumentDto htmlDocumentDto, int headingLevel, String tempHtml) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Pdf insert tempHtml to document.");
        if (builder == null) {
            return;
        }
        builder.getParagraphFormat().setStyleIdentifier(headingLevel);
        WordDocumentUtils.setTitleFont(builder.getParagraphFormat(), StringUtils.isBlank((CharSequence)htmlDocumentDto.getDocRelativeName()));
        builder.startBookmark(htmlDocumentDto.getNaviPosition() + " " + htmlDocumentDto.getDocTitleName());
        builder.writeln(htmlDocumentDto.getNaviPosition() + " " + htmlDocumentDto.getDocTitleName());
        builder.endBookmark(htmlDocumentDto.getNaviPosition() + " " + htmlDocumentDto.getDocTitleName());
        outlineLevels.add(htmlDocumentDto.getNaviPosition() + " " + htmlDocumentDto.getDocTitleName(), headingLevel);
        try {
            builder.insertHtml(tempHtml);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Pdf insert tempHtml to document error.", (Throwable)e);
        }
    }

    private static void setTitleFont(ParagraphFormat paragraphFormat, boolean isPathBlank) {
        paragraphFormat.getStyle().getFont().setSize(18.0);
        paragraphFormat.getStyle().getFont().setBold(true);
        paragraphFormat.setLineSpacing(12.0);
        if (isPathBlank) {
            paragraphFormat.getStyle().getFont().setSize(21.0);
        }
    }

    public static void setCompleteStyle(String saveNameNoSuffix, Document document, DocumentBuilder builder, boolean isSettingHeadAndFooter) throws Exception {
        if (document == null || builder == null) {
            return;
        }
        builder.getParagraphFormat().setStyleIdentifier(66);
        builder.getParagraphFormat().getStyle().getFont().setSize(10.0);
        for (Object obj : document.getChildNodes(5, true)) {
            if (!(obj instanceof Table)) continue;
            Table table = (Table)obj;
            table.autoFit(1);
        }
        builder.getParagraphFormat().getStyle().getFont().setSize(10.0);
        WordDocumentUtils.setStyle(document, builder, saveNameNoSuffix, isSettingHeadAndFooter);
    }

    public static void replaceSymbolFontForPdf(Document document) {
        if (document == null) {
            return;
        }
        for (List list : document.getLists()) {
            for (ListLevel level : list.getListLevels()) {
                if (!StringUtils.equals((CharSequence)level.getFont().getName(), (CharSequence)SYMBOL_FONT_NAME) || !StringUtils.equals((CharSequence)level.getNumberFormat(), (CharSequence)UNICODE_CHARACTER_SQUARE)) continue;
                level.setNumberFormat(UNICODE_CHARACTER_BULLET);
            }
        }
    }

    private static void setStyle(Document document, DocumentBuilder builder, String headerContent, boolean isSettingHeadAndFooter) throws Exception {
        if (document == null || builder == null) {
            return;
        }
        WordDocumentUtils.setPageLayout(builder);
        if (isSettingHeadAndFooter) {
            WordDocumentUtils.setHeader(document, builder, headerContent);
            WordDocumentUtils.setFooter(builder);
        }
        WordDocumentUtils.setFontStyle(builder);
    }

    private static void setFontStyle(DocumentBuilder builder) {
        if (builder == null) {
            return;
        }
        builder.getParagraphFormat().clearFormatting();
        builder.getParagraphFormat().getStyle().getFont().setSize(10.0);
        builder.getParagraphFormat().getStyle().getFont().setBold(false);
    }

    private static void setPageLayout(DocumentBuilder builder) {
        if (builder == null) {
            return;
        }
        builder.getPageSetup().setPageWidth(595.0);
        builder.getPageSetup().setPageHeight(842.0);
        builder.getPageSetup().setTopMargin(36.0);
        builder.getPageSetup().setBottomMargin(36.0);
        builder.getPageSetup().setLeftMargin(40.0);
        builder.getPageSetup().setRightMargin(40.0);
        builder.getPageSetup().setHeaderDistance(2.0);
        builder.getPageSetup().setFooterDistance(2.0);
    }

    private static void setHeader(Document document, DocumentBuilder builder, String headerContent) throws Exception {
        if (document == null || builder == null) {
            return;
        }
        builder.moveToHeaderFooter(1);
        builder.getParagraphFormat().setAlignment(0);
        Run runHead = new Run((DocumentBase)document, (String)StringUtils.defaultIfBlank((CharSequence)headerContent, (CharSequence)""));
        runHead.getFont().setSize(7.5);
        Paragraph header = builder.insertParagraph();
        header.appendChild((Node)runHead);
        Border borderHeader = builder.getParagraphFormat().getBorders().getBottom();
        borderHeader.setLineStyle(1);
    }

    private static void setFooter(DocumentBuilder builder) throws Exception {
        if (builder == null) {
            return;
        }
        builder.moveToHeaderFooter(3);
        builder.getFont().setSize(7.5);
        Table table = builder.startTable();
        Cell date = builder.insertCell();
        date.getCellFormat().setTopPadding(0.0);
        date.getCellFormat().setBottomPadding(0.0);
        date.getCellFormat().setLeftPadding(0.0);
        date.getCellFormat().setRightPadding(0.0);
        builder.getParagraphFormat().setAlignment(0);
        builder.insertField("DATE \\@ \"yyyy-MM-dd\"");
        builder.insertCell();
        builder.getParagraphFormat().setAlignment(2);
        builder.insertField("PAGE", "");
        builder.endRow();
        table.clearBorders();
        table.setBorder(3, 1, 0.25, Color.BLACK, true);
        table.setLeftPadding(0.0);
        table.setRightPadding(0.0);
        builder.endTable();
    }

    public static void resizeImgForCells(Document document) throws Exception {
        LayoutCollector collector = new LayoutCollector(document);
        LayoutEnumerator enumerator = new LayoutEnumerator(document);
        NodeCollection cells = document.getChildNodes(7, true);
        for (Cell cell : cells) {
            Object entity;
            Paragraph firstParagraph = cell.getFirstParagraph();
            if (firstParagraph == null || (entity = collector.getEntity((Node)firstParagraph)) == null) continue;
            enumerator.setCurrent(entity);
            while (enumerator.getType() != 16) {
                enumerator.moveParent();
            }
            NodeCollection shapes = cell.getChildNodes(18, true);
            for (Shape shape : shapes) {
                if (!shape.isImage()) {
                    return;
                }
                ImageData imageData = shape.getImageData();
                if (imageData == null) {
                    return;
                }
                Rectangle2D.Float rectangle = null;
                try {
                    rectangle = enumerator.getRectangle();
                }
                catch (Exception e) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get rectangle failed.", (Throwable)e);
                }
                if (rectangle == null || ((RectangularShape)rectangle).isEmpty()) {
                    return;
                }
                WordDocumentUtils.resizeImg(shape, rectangle);
            }
        }
    }

    private static void resizeImg(Shape image, Rectangle2D rectangle) {
        BigDecimal imgWidth = new BigDecimal(String.valueOf(image.getWidth()));
        BigDecimal imgHeight = new BigDecimal(String.valueOf(image.getHeight()));
        BigDecimal widthRatio = imgWidth.divide(new BigDecimal(String.valueOf(rectangle.getWidth())), 5, RoundingMode.UP);
        BigDecimal heightRatio = imgHeight.divide(new BigDecimal(String.valueOf(rectangle.getHeight())), 5, RoundingMode.UP);
        if (widthRatio.compareTo(BigDecimal.ONE) < 1 && heightRatio.compareTo(BigDecimal.ONE) < 1) {
            return;
        }
        BigDecimal ratio = widthRatio.max(heightRatio);
        double width = imgWidth.divide(ratio, 5, RoundingMode.UP).multiply(IMAGE_RESIZE_RATIO).doubleValue();
        try {
            image.setWidth(width);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Set image width failed.", (Throwable)e);
        }
    }

    public static void resetBottomLineForCells(Document document) throws Exception {
        for (Table table : document.getChildNodes(5, true)) {
            if (table.getParentNode().getNodeType() == 4) continue;
            for (Row row : table.getChildNodes(6, true)) {
                for (Cell cell : row.getChildNodes(7, true)) {
                    cell.getCellFormat().getBorders().getBottom().setLineStyle(0);
                    cell.getCellFormat().getBorders().getBottom().setLineStyle(1);
                }
            }
        }
    }

    public static void setRepeatedTableHead(Document document) {
        for (Table table : document.getChildNodes(5, true)) {
            RowCollection rows = table.getRows();
            Row headRow = rows.get(0);
            if (headRow == null) continue;
            headRow.getRowFormat().setHeadingFormat(true);
        }
    }
}

