/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.common.service.impl;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.adapter.storage.resource.PathResourceInitHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.process.AppRestartProcess;
import com.huawei.support.icslite.common.resources.software.dto.SoftwareDto;
import com.huawei.support.icslite.common.resources.software.info.SoftwareInfo;
import com.huawei.support.icslite.common.service.IcsCommonService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsCommonServiceHandler
implements IcsCommonService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsCommonServiceHandler.class);
    private static final Map<String, String> DOUBLE_CLICK_LIB_PATH_MAP_POOL = new LinkedHashMap<String, String>();
    private String appRootDir;
    private String appBinDir;
    private String upgradeJarPath;
    private String upgradeZipPath;
    private String upgraderJavaHomeDir;
    private String webAppPath = PathResourceInitHandler.getInstance().getWebAppPath();
    private String programDataPath;
    private String appDataPath;
    private String doubleClickLibPath;

    private IcsCommonServiceHandler() {
        this.appRootDir = PathResourceInitHandler.getInstance().getAppRootDir();
        this.appBinDir = this.appRootDir + File.separator + "bin";
        this.upgradeJarPath = this.appBinDir + File.separator + "icsLiteUpgrade.jar";
        this.upgradeZipPath = this.appBinDir + File.separator + "icsLiteUpgrade.zip";
        this.upgraderJavaHomeDir = this.appRootDir + File.separator + "upgrader" + File.separator + "jre";
        this.initProgramDataPath();
        this.initAppDataPath();
    }

    public static IcsCommonServiceHandler getInstance() {
        return IcsCommonServiceHandlerHolder.INSTANCE;
    }

    @Override
    public SoftwareDto getSoftwareInfo() {
        return SoftwareInfo.getSoftwareInfo(this.appRootDir);
    }

    @Override
    public String getAppBinDir() {
        return this.appBinDir;
    }

    @Override
    public String getAppRootDir() {
        return this.appRootDir;
    }

    @Override
    public String getUpgraderJavaHomeDir() {
        return this.upgraderJavaHomeDir;
    }

    @Override
    public String getWebAppPath() {
        return this.webAppPath;
    }

    @Override
    public String getAppVersion() {
        SoftwareDto softwareInfo = this.getSoftwareInfo();
        String appVersion = "";
        if (softwareInfo != null) {
            appVersion = softwareInfo.getSoftVersion();
        }
        return appVersion;
    }

    @Override
    public String getComponentFilePath(String dirName, String fileName) {
        return this.getAppRootDir() + File.separator + dirName + File.separator + fileName;
    }

    @Override
    public String getSysAppDataPath() {
        return this.appDataPath;
    }

    private void initAppDataPath() {
        String appDataStr = System.getenv("appdata");
        if (StringUtils.isBlank((CharSequence)appDataStr)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The appDataStr is blank.");
            return;
        }
        File appDataDir = FileUtils.getFile((String[])new String[]{appDataStr});
        if (appDataDir == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The appDataDir is not exist.");
            return;
        }
        String canonicalPath = null;
        try {
            canonicalPath = appDataDir.getCanonicalPath();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "get appDataDir fail", (Throwable)e);
        }
        String userHome = System.getProperty("user.home");
        if (!(appDataDir.exists() && appDataDir.isDirectory() && StringUtils.startsWithIgnoreCase((CharSequence)canonicalPath, (CharSequence)userHome))) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Illegal AppData path");
        } else {
            this.appDataPath = canonicalPath + File.separator + "ICSLite";
        }
    }

    @Override
    public String getSysProgramDataPath() {
        return this.programDataPath;
    }

    public boolean isExistDisk(String path) {
        int diskSeparator = path.indexOf(":");
        String diskChar = path.substring(0, diskSeparator + 1);
        File file = FileUtils.getFile((String[])new String[]{diskChar});
        return file.exists();
    }

    private void initProgramDataPath() {
        String programData;
        Map<String, String> getenv = System.getenv();
        String systemDriveStr = getenv.get("SystemDrive");
        String programDataStr = systemDriveStr + File.separator + "ProgramData";
        if (!StringUtils.equalsIgnoreCase((CharSequence)programDataStr, (CharSequence)(programData = System.getenv("ProgramData")))) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "programData path is error: {0}", new Object[]{programData});
        }
        this.programDataPath = programData + File.separator + "ICSLite" + File.separator;
    }

    @Override
    public String getDefaultResPath() {
        return this.getAppRootDir() + CommonConstants.DEFAULT_RESOURCE_DIR;
    }

    @Override
    public void startApp() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getAppRootDir() + File.separator + "Startup.exe");
        SystemCommandUtils.exec(commands, new HashMap());
    }

    @Override
    public void exitApp() {
        SystemCommandUtils.exec(this.getExitCommand("icslite_index.exe"), new HashMap());
        SystemCommandUtils.exec(this.getExitCommand("icslite_tomcat.exe"), new HashMap());
        SystemCommandUtils.exec(this.getExitCommand("icslite_system.exe"), new HashMap());
        SystemCommandUtils.exec(this.getExitCommand("icslite_preview.exe"), new HashMap());
        SystemCommandUtils.exec(this.getExitCommand("icslite_export.exe"), new HashMap());
        SystemCommandUtils.exec(this.getExitCommand("icslite_print.exe"), new HashMap());
    }

    @Override
    public void restartApp() {
        String javaHome = IcsLiteStorageInstance.getInstance().getJavaHomePath();
        List cmdList = SystemCommandUtils.getProcessArgs(AppRestartProcess.class, (String)javaHome, (String)"javaw.exe", new ArrayList(), new ArrayList());
        ProcessBuilder builder = new ProcessBuilder(cmdList);
        try {
            builder.start();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "AppReloadProcess process error", (Throwable)e);
        }
    }

    @Override
    public void exitUpgrader() {
        SystemCommandUtils.exec(this.getExitCommand("icslite_upgrader.exe"), new HashMap());
    }

    @Override
    public void startUpgrader() {
        String upgraderJavaBinPath = this.upgraderJavaHomeDir + File.separator + "bin" + File.separator;
        String upgraderExePath = upgraderJavaBinPath + "icslite_upgrader.exe";
        try {
            if (StringUtils.isBlank((CharSequence)this.upgradeJarPath)) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "startUpgrader upgradeJarPath is blank");
                return;
            }
            if (!FileUtils.getFile((String[])new String[]{this.upgradeJarPath}).exists()) {
                IcsFileUtils.copyFile((String)this.upgradeZipPath, (String)this.upgradeJarPath);
            }
            if (StringUtils.isBlank((CharSequence)upgraderExePath)) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "startUpgrader upgraderExePath is blank");
                return;
            }
            if (!FileUtils.getFile((String[])new String[]{upgraderExePath}).exists()) {
                IcsFileUtils.copyFile((String)(upgraderJavaBinPath + "javaw.exe"), (String)upgraderExePath);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "startUpgrader copy file error.", (Throwable)e);
        }
        SystemCommandUtils.exec(this.getExitCommand("icslite_upgrader.exe"), new HashMap());
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "startUpgrader thread sleep error.", (Throwable)e);
        }
        SystemCommandUtils.exec(this.getStartUpgraderCommand(upgraderExePath, this.upgradeJarPath), new HashMap());
    }

    @Override
    public List<String> getExitCommand(String processName) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("taskkill");
        commands.add("/f");
        commands.add("/fi");
        String processNameTemp = "\"imagename eq " + processName + "\"";
        commands.add(processNameTemp);
        return commands;
    }

    public List<String> getStartUpgraderCommand(String exePath, String jarPath) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("\"" + exePath + "\"");
        commands.add("-jar");
        commands.add("\"" + jarPath + "\"");
        return commands;
    }

    @Override
    public String getStartupExePath() {
        return this.getAppRootDir() + File.separator + "Startup.exe";
    }

    @Override
    public String getDoubleClickLibPath() {
        return this.doubleClickLibPath;
    }

    @Override
    public boolean setDoubleClickLibPath(String libPath) {
        this.doubleClickLibPath = libPath;
        return !StringUtils.isBlank((CharSequence)this.doubleClickLibPath);
    }

    @Override
    public Map<String, String> getDoubleClickLibPathPool() {
        return DOUBLE_CLICK_LIB_PATH_MAP_POOL;
    }

    @Override
    public void setDoubleClickLibPathPool(String docId, String libPath) {
        this.getDoubleClickLibPathPool().put(docId, libPath);
    }

    private static class IcsCommonServiceHandlerHolder {
        private static final IcsCommonServiceHandler INSTANCE = new IcsCommonServiceHandler();

        private IcsCommonServiceHandlerHolder() {
        }
    }
}

