/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.utils.IOUtils;

public class CacheUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CacheUtils.class);

    private CacheUtils() {
    }

    public static <T> Cache<String, T> newCacheInstance(int timeSpan, TimeUnit timeUnit, int size) {
        if (size <= 0) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal parameter");
            throw new UnsupportedOperationException("Illegal parameter");
        }
        RemovalListener listener = notification -> {
            CodeCCUtils.INSTANCE.warnLog(LOG, "data key:" + (String)notification.getKey() + "is removed from local record!");
            Object value = notification.getValue();
            if (value instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)value));
            }
        };
        Cache cache = 0 <= timeSpan && timeUnit == null ? CacheBuilder.newBuilder().maximumSize((long)size).removalListener(listener).build() : CacheBuilder.newBuilder().maximumSize((long)size).expireAfterAccess((long)timeSpan, timeUnit).removalListener(listener).build();
        return cache;
    }

    public static <T> Cache<String, T> newCacheInstance(int size) {
        TimeUnit timeUnit = null;
        return CacheUtils.newCacheInstance(0, timeUnit, size);
    }
}

