/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.cbb;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OkHttpUtil {
    public static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final int MAXIDLECONNECTIONS = 10;
    private static final long KEEPALIVEDURATION = 300L;
    private static final long READTIMEOUT = 300L;
    private static final long CONNTIMEOUT = 5L;

    private OkHttpUtil() {
    }

    public static OkHttpClient newHttpClient() {
        return OkHttpUtil.newHttpClient(null, null, OkHttpUtil.getDefaultPool(), 300L, 5L);
    }

    public static OkHttpClient newHttpClient(String userName, String pwd) {
        return OkHttpUtil.newHttpClient(userName, pwd, OkHttpUtil.getDefaultPool(), 300L, 5L);
    }

    public static OkHttpClient newHttpClient(String userName, String pwd, ConnectionPool pool, long readTimeOut, long connTimeOut) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        TimeUnit unit = TimeUnit.SECONDS;
        builder = builder.readTimeout(readTimeOut, unit);
        builder = builder.connectTimeout(connTimeOut, unit);
        builder = builder.connectionPool(pool);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userName, pwd})) {
            builder = builder.authenticator((Authenticator)new ServiceAuthenticator(userName, pwd));
        }
        return builder.build();
    }

    public static Request newHttpGetRequest(String url, Map<String, String> headers) {
        return OkHttpUtil.newHttpRequest(Method.GET, url, null, headers);
    }

    public static Request newHttpRequest(Method httpMethod, String url, String bodyContent, Map<String, String> headers) {
        RequestBody body;
        Request.Builder builder = new Request.Builder();
        builder = builder.url(url);
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                builder = builder.addHeader(header.getKey(), header.getValue());
            }
        }
        if (Method.DELETE.equals((Object)httpMethod)) {
            if (StringUtils.isNotBlank((CharSequence)bodyContent)) {
                body = RequestBody.Companion.create(bodyContent, MEDIA_TYPE);
                builder = builder.post(body);
            } else {
                builder = builder.delete();
            }
        } else {
            body = null;
            if (StringUtils.isNotBlank((CharSequence)bodyContent)) {
                body = RequestBody.Companion.create(bodyContent, MEDIA_TYPE);
            }
            builder = builder.method(httpMethod.toString(), body);
        }
        return builder.build();
    }

    public static String get(OkHttpClient client, String url) throws IOException {
        return OkHttpUtil.execute(client, Method.GET, url, null, null);
    }

    public static String post(OkHttpClient client, String url, String bodyContent, Map<String, String> headers) throws IOException {
        return OkHttpUtil.execute(client, Method.POST, url, bodyContent, headers);
    }

    public static String delete(OkHttpClient client, String url, String bodyContent, Map<String, String> headers) throws IOException {
        return OkHttpUtil.execute(client, Method.DELETE, url, bodyContent, headers);
    }

    public static String put(OkHttpClient client, String url, String bodyContent, Map<String, String> headers) throws IOException {
        return OkHttpUtil.execute(client, Method.PUT, url, bodyContent, headers);
    }

    public static String head(OkHttpClient client, String url, String bodyContent, Map<String, String> headers) throws IOException {
        return OkHttpUtil.execute(client, Method.HEAD, url, bodyContent, headers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String execute(OkHttpClient client, Method method, String url, String bodyContent, Map<String, String> headers) throws IOException {
        if (client == null) {
            throw new IOException("client is null.");
        }
        Request request = OkHttpUtil.newHttpRequest(method, url, bodyContent, headers);
        try (Response response = client.newCall(request).execute();){
            ResponseBody body = response.body();
            String string = body.string();
            return string;
        }
    }

    private static ConnectionPool getDefaultPool() {
        return new ConnectionPool(10, 300L, TimeUnit.SECONDS);
    }

    public static class ServiceAuthenticator
    implements Authenticator {
        private String credential;

        public ServiceAuthenticator(String userName, String pwd) {
            this.credential = Credentials.basic((String)userName, (String)pwd);
        }

        public Request authenticate(Route route, Response response) {
            return response.request().newBuilder().header("Authorization", this.credential).build();
        }
    }

    static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD;

    }
}

