/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.cbb.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.wsf.core.HWEncoder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class XssEncodeUtil {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(XssEncodeUtil.class);

    private XssEncodeUtil() {
    }

    public static String encodeJsonForHtml(String jsonStr) {
        return XssEncodeUtil.encodeJson(jsonStr, EncodeType.ENCODE_FOR_HTML, false);
    }

    public static String encodeJsonForHtml(String jsonStr, boolean isOrderedField) {
        return XssEncodeUtil.encodeJson(jsonStr, EncodeType.ENCODE_FOR_HTML, isOrderedField);
    }

    public static String encodeJsonForJavaScript(String jsonStr) {
        return XssEncodeUtil.encodeJson(jsonStr, EncodeType.ENCODE_FOR_JAVASCRIPT, false);
    }

    public static String encodeJsonForJavaScript(String jsonStr, boolean isOrderedField) {
        return XssEncodeUtil.encodeJson(jsonStr, EncodeType.ENCODE_FOR_JAVASCRIPT, isOrderedField);
    }

    private static void encodeJsonObject(JSONObject jsonObject, EncodeType encodeType) {
        if (jsonObject.isEmpty()) {
            return;
        }
        Map resultMap = jsonObject.getInnerMap();
        for (Map.Entry entry : resultMap.entrySet()) {
            Object val = entry.getValue();
            if (val instanceof String) {
                String valEncode = XssEncodeUtil.encodeString((String)val, encodeType);
                entry.setValue(valEncode);
                continue;
            }
            if (val instanceof JSONObject) {
                XssEncodeUtil.encodeJsonObject((JSONObject)val, encodeType);
                continue;
            }
            if (!(val instanceof JSONArray)) continue;
            XssEncodeUtil.encodeJsonArray((JSONArray)val, encodeType);
        }
    }

    private static void encodeJsonArray(JSONArray jsonArray, EncodeType encodeType) {
        if (jsonArray.isEmpty()) {
            return;
        }
        int index = 0;
        for (Object obj : jsonArray) {
            if (obj instanceof JSONObject) {
                XssEncodeUtil.encodeJsonObject((JSONObject)obj, encodeType);
            } else if (obj instanceof JSONArray) {
                XssEncodeUtil.encodeJsonArray((JSONArray)obj, encodeType);
            } else if (obj instanceof String) {
                String valEncode = XssEncodeUtil.encodeString((String)obj, encodeType);
                jsonArray.set(index, (Object)valEncode);
            }
            ++index;
        }
    }

    private static String encodeString(String string, EncodeType encodeType) {
        String valEncode;
        switch (encodeType) {
            case ENCODE_FOR_HTML: {
                valEncode = HWEncoder.encodeForHTML((String)string);
                break;
            }
            case ENCODE_FOR_JAVASCRIPT: {
                valEncode = HWEncoder.encodeForJavaScript((String)string);
                break;
            }
            default: {
                valEncode = HWEncoder.encodeForHTML((String)string);
            }
        }
        return valEncode;
    }

    private static String encodeJson(String jsonStr, EncodeType encodeType, boolean isOrderedField) {
        Object obj;
        block7: {
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                return jsonStr;
            }
            try {
                obj = isOrderedField ? JSONObject.parse((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField}) : JSONObject.parse((String)jsonStr);
                if (obj == null) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "unexpected format, the param parsed result is null.");
                    return jsonStr;
                }
                if (obj instanceof JSONObject) {
                    XssEncodeUtil.encodeJsonObject((JSONObject)obj, encodeType);
                    break block7;
                }
                if (obj instanceof JSONArray) {
                    XssEncodeUtil.encodeJsonArray((JSONArray)obj, encodeType);
                    break block7;
                }
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "unexpected format, the obj type is {}", new Object[]{obj.getClass()});
                return jsonStr;
            }
            catch (JSONException e) {
                throw new JSONException("parse json error, " + e.getMessage());
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "encode object/array error.", (Throwable)e);
                return jsonStr;
            }
        }
        return JSON.toJSONString((Object)obj);
    }

    static enum EncodeType {
        ENCODE_FOR_HTML,
        ENCODE_FOR_JAVASCRIPT;

    }
}

