/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.db;

import com.huawei.security.validator.util.Resources;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public enum SqlSessionFactorySingleton {
    INSTANCE;

    private static final CommonLogger LOGGER;
    private SqlSessionFactory sqlSessionFactory = null;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void buildSqlSessionFactory(String resMybatisConfig, String userName, String pwd, String bootPassword, String icsLogDir) {
        try (InputStream inputStream = Resources.getResourceAsStream((String)resMybatisConfig);
             InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.setProperty("username", userName);
            properties.setProperty("password", pwd);
            properties.setProperty("bootPassword", bootPassword);
            properties.setProperty("icsLogDir", icsLogDir);
            this.sqlSessionFactory = new SqlSessionFactoryBuilder().build((Reader)reader, properties);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Build SqlSessionFactory fail.", (Throwable)e);
        }
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    static {
        LOGGER = CommonLoggerFactory.getLogger(SqlSessionFactorySingleton.class);
    }
}

