/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.file;

import com.huawei.support.cbb.util.io.IoCloseUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsFileUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsFileUtils.class);
    private static final int MAX_LENGTH = 255;
    private static boolean isPreserveFileDate = false;
    private static String osName = System.getProperty("os.name");
    private static final List<String> SECURE_DIR = Collections.unmodifiableList(Arrays.asList("/dm/storageservice/ops", "/tctHome/hedexhome"));
    private static final List<String> SAAS_IMAGE_TYPES = Collections.unmodifiableList(Arrays.asList(".PNG", ".png", ".JPG", ".jpg", ".GIF", ".gif"));

    private IcsFileUtils() {
    }

    public static String getCanonicalPath(File file) {
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "FileUtil getCanonicalPath error.");
        }
        return path;
    }

    public static String getFileSuffix(File file) {
        if (file == null || file.isDirectory()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "file is null or directory");
            return "";
        }
        String fileName = file.getName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "fileName is empty");
            return "";
        }
        return fileName.substring(fileName.indexOf("."));
    }

    public static String getFileSuffix(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "file path is empty");
            return "";
        }
        File file = FileUtils.getFile((String[])new String[]{filePath});
        return IcsFileUtils.getFileSuffix(file);
    }

    public static String getFileSuffixByFileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "file name is empty");
            return "";
        }
        return fileName.substring(fileName.indexOf(".") + 1);
    }

    /*
     * Exception decompiling
     */
    public static String readFileContent(String path, String tag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeFileContent(String strFilename, String strBuffer) {
        boolean isMkdirs;
        File file = FileUtils.getFile((String[])new String[]{strFilename});
        String parent = file.getParent();
        File parentFile = FileUtils.getFile((String[])new String[]{parent});
        if (!parentFile.exists() && !(isMkdirs = parentFile.mkdirs())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "FileUtil writeFileContent fail.");
            return;
        }
        try (BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            fileWriter.write(strBuffer);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "FileUtil writeFileContent error.");
        }
    }

    public static String validateFilePath(String targetDir, String requestFile) {
        String result = null;
        try {
            File file = FileUtils.getFile((String[])new String[]{targetDir, requestFile});
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath.startsWith(targetDir)) {
                result = canonicalPath;
            }
        }
        catch (IOException ex) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "validate path error.");
        }
        return result;
    }

    public static String parseValidatePath(String validatePath) {
        String appDir = null;
        if (StringUtils.isNotBlank((CharSequence)validatePath)) {
            File file = FileUtils.getFile((String[])new String[]{validatePath});
            String targetDir = file.getParent();
            String requestFile = file.getName();
            targetDir = targetDir + File.separator;
            appDir = IcsFileUtils.validateFilePath(targetDir, requestFile);
        }
        return appDir;
    }

    public static boolean delFile(String validatePath) {
        boolean isDelete = true;
        File file = FileUtils.getFile((String[])new String[]{validatePath});
        if (file.isFile()) {
            isDelete = file.delete();
            if (!isDelete) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "del File error, filename: " + file.getName());
            }
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "del File error, is not file, filename: " + file.getName());
        }
        return isDelete;
    }

    public static boolean delFileOrDir(File file, String appPath) {
        boolean isDelete = true;
        if (file == null) {
            return isDelete;
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(file);
        while (!queue.isEmpty()) {
            File parentFile;
            File queueFile = (File)queue.poll();
            isDelete = FileUtils.deleteQuietly((File)queueFile);
            if (!isDelete) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "delete file fail. filename:" + file.getName());
            }
            if ((parentFile = queueFile.getParentFile()) == null) {
                return isDelete;
            }
            String parentPath = IcsFileUtils.getCanonicalPath(parentFile);
            if (StringUtils.isBlank((CharSequence)appPath) || !StringUtils.startsWith((CharSequence)parentPath, (CharSequence)appPath)) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "not app dir, not handle.");
                return isDelete;
            }
            Object[] listFiles = parentFile.listFiles();
            if (!ArrayUtils.isEmpty((Object[])listFiles)) continue;
            queue.add(parentFile);
        }
        return isDelete;
    }

    public static boolean isExist(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "path is empty");
            return false;
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        return file.exists();
    }

    public static boolean isFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        String path = IcsFileUtils.getCanonicalPath(file);
        if ("".equals(path)) {
            return false;
        }
        if (path.length() > 255) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "The file path contains more than 255 characters.");
            return false;
        }
        return true;
    }

    public static boolean isInSecureDir(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "path is empty");
            return false;
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        try {
            String canonicalPath = file.getCanonicalPath();
            if (StringUtils.isBlank((CharSequence)canonicalPath)) {
                return false;
            }
            if (IcsFileUtils.isWindows()) {
                return true;
            }
            for (String prefix : SECURE_DIR) {
                if (!canonicalPath.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getCanonicalPath fail");
            return false;
        }
    }

    public static boolean isInSecureDir(String path, String secureDir) {
        String canonicalPath;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{path, secureDir})) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "path or secureDir is empty.");
            return false;
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getCanonicalPath fail", (Throwable)e);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)canonicalPath)) {
            return false;
        }
        if (IcsFileUtils.isWindows()) {
            return true;
        }
        return canonicalPath.startsWith(secureDir);
    }

    public static boolean isDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String path = IcsFileUtils.getCanonicalPath(file);
        if ("".equals(path)) {
            return false;
        }
        return path.length() <= 255;
    }

    public static void copyFile(String resource, String target) throws IOException {
        File srcFile = FileUtils.getFile((String[])new String[]{resource});
        File tarFile = FileUtils.getFile((String[])new String[]{target});
        FileUtils.copyFile((File)srcFile, (File)tarFile, (boolean)isPreserveFileDate);
    }

    public static void copyDirectory(String srcDir, String tarDir) throws IOException {
        File srcFile = FileUtils.getFile((String[])new String[]{srcDir});
        File tarFile = FileUtils.getFile((String[])new String[]{tarDir});
        FileUtils.copyDirectory((File)srcFile, (File)tarFile, (boolean)isPreserveFileDate);
    }

    public static void deleteFile(File file) throws IOException {
        if (file != null && file.exists()) {
            FileUtils.forceDelete((File)file);
        }
    }

    public static CharsetMatch getCharsetMatch(InputStream inStream) {
        CharsetMatch charsetMatch = null;
        if (inStream == null) {
            return charsetMatch;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inStream);
        CharsetDetector charsetDetector = new CharsetDetector();
        try {
            charsetDetector.setText((InputStream)bufferedInputStream);
            charsetMatch = charsetDetector.detect();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Can not get charset matcher from input stream.");
        }
        return charsetMatch;
    }

    public static byte[] getFileBytes(String filePath, long start, int len) {
        byte[] bytes = null;
        File file = FileUtils.getFile((String[])new String[]{filePath});
        Path path = null;
        int numRead = 0;
        try {
            path = Paths.get(file.getCanonicalPath(), new String[0]);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "file.getCanonicalPath fail.");
            return bytes;
        }
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.allocate(len);
            if (channel != null && (numRead = channel.read(buffer, start)) != -1) {
                bytes = buffer.array();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "get bytes fail.");
        }
        return bytes;
    }

    public static String getFileSeparator() {
        if (IcsFileUtils.isWindows()) {
            return "\\\\";
        }
        return "/";
    }

    public static boolean isCheckPicName(String picFileName) {
        if (StringUtils.isBlank((CharSequence)picFileName)) {
            return false;
        }
        String fileSuffix = picFileName.substring(picFileName.lastIndexOf("."));
        return StringUtils.isNotEmpty((CharSequence)fileSuffix) && SAAS_IMAGE_TYPES.contains(fileSuffix);
    }

    public static String getCanonicalPath(String filePath) {
        String tempPath = filePath;
        File file = FileUtils.getFile((String[])new String[]{tempPath});
        if (file != null) {
            try {
                tempPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "getCanonicalPath fail.");
            }
        }
        return tempPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromStream(InputStream inputStream) {
        String content;
        Reader reader;
        block6: {
            CharsetMatch charsetMatch = IcsFileUtils.getCharsetMatch(inputStream);
            reader = null;
            content = "";
            if (charsetMatch != null) {
                reader = charsetMatch.getReader();
            }
            if (reader != null) break block6;
            String string = content;
            IoCloseUtil.closeQuietly((Closeable[])new Closeable[]{reader});
            return string;
        }
        try {
            content = IOUtils.toString((Reader)reader);
        }
        catch (IOException e) {
            try {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Can't get content from input stream.");
            }
            catch (Throwable throwable) {
                IoCloseUtil.closeQuietly((Closeable[])new Closeable[]{reader});
                throw throwable;
            }
            IoCloseUtil.closeQuietly((Closeable[])new Closeable[]{reader});
        }
        IoCloseUtil.closeQuietly((Closeable[])new Closeable[]{reader});
        return content;
    }

    private static boolean isWindows() {
        return osName.toLowerCase(Locale.ENGLISH).contains("windows");
    }
}

