/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.json.JsonSanitizer;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JsonUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static Map<String, Object> stringToMap(String jsonString) {
        try {
            return (Map)JsonUtils.readValue(JsonSanitizer.sanitize((String)jsonString), Map.class);
        }
        catch (JsonParseException e) {
            throw new JsonException("Illegal JSON format", e);
        }
        catch (JsonMappingException e) {
            throw new JsonException("JSON mapping error", e);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "string to map has Exception", (Throwable)e);
            throw new JsonException("Unknow error");
        }
    }

    public static JSONObject getJsonData(String fileName) {
        JSONObject jsonData = null;
        String data = IcsFileUtils.readFileContent(fileName, null);
        try {
            jsonData = JSON.parseObject((String)data);
        }
        catch (JSONException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Parse {0} json file failed: ------>", new Object[]{fileName});
        }
        return jsonData;
    }

    public static TreeMap<String, Object> parseJsonToMap(JSONObject json) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof JSONArray) {
                ArrayList<TreeMap<String, Object>> list = new ArrayList<TreeMap<String, Object>>();
                for (JSONObject json2 : (JSONArray)value) {
                    list.add(JsonUtils.parseJsonToMap(json2));
                }
                map.put(key, list);
                continue;
            }
            if (value instanceof JSONObject) {
                map.put(key, JsonUtils.parseJsonToMap((JSONObject)value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<?> stringToList(String jsonString) {
        try {
            return (List)JsonUtils.readValue(JsonSanitizer.sanitize((String)jsonString), List.class);
        }
        catch (JsonParseException e) {
            throw new JsonException("Illegal JSON format", e);
        }
        catch (JsonMappingException e) {
            throw new JsonException("JSON mapping error", e);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "string to json has Exception", (Throwable)e);
            throw new JsonException("Unknow error");
        }
    }

    public static String objectToString(Object object) {
        String jsonString;
        try {
            jsonString = mapper.writeValueAsString(object);
        }
        catch (JsonParseException e) {
            throw new JsonException("ObjectToString Illegal json format", e);
        }
        catch (JsonMappingException e) {
            throw new JsonException("ObjectToString Json mapping error", e);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "string to json has Exception", (Throwable)e);
            throw new JsonException("ObjectToString occur error");
        }
        return jsonString.replace("\"callbacks\":[{}],", "");
    }

    public static <T> T stringToBean(String jsonString, Class<T> beanClass) {
        return JsonUtils.fromString(jsonString, beanClass);
    }

    public static <T> T fromString(String jsonString, Class<T> beanClass) {
        try {
            return (T)mapper.readValue(JsonSanitizer.sanitize((String)jsonString), beanClass);
        }
        catch (JsonParseException e) {
            throw new JsonException("FromString Illegal JSON format", e);
        }
        catch (JsonMappingException e) {
            throw new JsonException("FromString JSON mapping error", e);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Deserialize JSON string to object specified by beanClass. has Exception", (Throwable)e);
            throw new JsonException("FromString occur error");
        }
    }

    private static <T> T readValue(String json, Class objClass) throws JsonProcessingException {
        return (T)mapper.readValue(JsonSanitizer.sanitize((String)json), objClass);
    }

    public static final boolean isValid(String json) {
        try {
            if (JsonUtils.readValue(json, Map.class) == null) {
                return false;
            }
        }
        catch (JsonProcessingException ex) {
            try {
                if (JsonUtils.readValue(json, List.class) == null) {
                    return false;
                }
            }
            catch (JsonProcessingException ex1) {
                return false;
            }
        }
        return true;
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object object : (List)obj) {
                result.add(clazz.cast(object));
            }
            return result;
        }
        return result;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
    }

    public static class JsonException
    extends RuntimeException {
        private static final long serialVersionUID = -8249768965787946054L;

        public JsonException(String message, Throwable cause) {
            super(message, cause);
        }

        public JsonException(String message) {
            super(message);
        }
    }
}

