/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.response;

import com.huawei.support.icscbb.util.http.HttpStatusCode;
import com.huawei.support.icscbb.util.response.ResultCode;
import javax.servlet.http.HttpServletResponse;

public class ServiceResponse<T> {
    private String msg;
    private int code;
    private T data;

    public ServiceResponse() {
    }

    private ServiceResponse(String msg, int code, T data) {
        this.msg = msg;
        this.code = code;
        this.data = data;
    }

    private ServiceResponse(int code, T data) {
        this.code = code;
        this.data = data;
    }

    private ServiceResponse(String msg, int code) {
        this.msg = msg;
        this.code = code;
    }

    private ServiceResponse(int code) {
        this.code = code;
    }

    public static <T> ServiceResponse<T> getSuccess() {
        return new ServiceResponse<T>(ResultCode.SUCCESS.getRsultMsg(), ResultCode.SUCCESS.getReusltCode());
    }

    public static <T> ServiceResponse<T> getSuccess(String msg) {
        return new ServiceResponse<T>(msg, ResultCode.SUCCESS.getReusltCode());
    }

    public static <T> ServiceResponse<T> getSuccResponse(T data) {
        return new ServiceResponse<T>(ResultCode.SUCCESS.getRsultMsg(), ResultCode.SUCCESS.getReusltCode(), data);
    }

    public static <T> ServiceResponse<T> getSuccResponse(String msg, T data) {
        return new ServiceResponse<T>(msg, ResultCode.SUCCESS.getReusltCode(), data);
    }

    public static <T> ServiceResponse<T> getFormatErrorResponse(T data) {
        return new ServiceResponse<T>(ResultCode.FORMAT_ERROR.getRsultMsg(), ResultCode.FORMAT_ERROR.getReusltCode(), data);
    }

    public static <T> ServiceResponse<T> getError() {
        return new ServiceResponse<T>(ResultCode.ERROR.getRsultMsg(), ResultCode.ERROR.getReusltCode());
    }

    public static <T> ServiceResponse<T> getError(String msg) {
        return new ServiceResponse<T>(msg, ResultCode.ERROR.getReusltCode());
    }

    public static <T> ServiceResponse<T> getError(T data) {
        return new ServiceResponse<T>(ResultCode.ERROR.getRsultMsg(), ResultCode.ERROR.getReusltCode(), data);
    }

    public static <T> ServiceResponse<T> getIllegalParameter() {
        return new ServiceResponse<T>(ResultCode.ILLEGAL_PARAMETER.getRsultMsg(), ResultCode.ILLEGAL_PARAMETER.getReusltCode());
    }

    public static <T> ServiceResponse<T> getIllegalParameter(String diyMessage) {
        return new ServiceResponse<T>(diyMessage, ResultCode.ILLEGAL_PARAMETER.getReusltCode());
    }

    public static <T> ServiceResponse<T> getIllegalParameter(HttpServletResponse response) {
        if (response != null) {
            response.setStatus(HttpStatusCode.HTTP_STATUS_CODE_400.getCode());
        }
        return new ServiceResponse<T>(ResultCode.ILLEGAL_PARAMETER.getRsultMsg(), ResultCode.ILLEGAL_PARAMETER.getReusltCode());
    }

    public static <T> ServiceResponse<T> getIllegalParameter(String diyMessage, HttpServletResponse response) {
        if (response != null) {
            response.setStatus(HttpStatusCode.HTTP_STATUS_CODE_400.getCode());
        }
        return new ServiceResponse<T>(diyMessage, ResultCode.ILLEGAL_PARAMETER.getReusltCode());
    }

    public static <T> ServiceResponse<T> getSystemError(String diyMessage, HttpServletResponse response) {
        if (response != null) {
            response.setStatus(HttpStatusCode.HTTP_STATUS_CODE_500.getCode());
        }
        return new ServiceResponse<T>(diyMessage, ResultCode.ILLEGAL_PARAMETER.getReusltCode());
    }

    public static <T> ServiceResponse<T> getNoPermission() {
        return new ServiceResponse<T>(ResultCode.NO_PERMISSION.getRsultMsg(), ResultCode.NO_PERMISSION.getReusltCode());
    }

    public static <T> ServiceResponse<T> getNoPermission(HttpServletResponse response) {
        if (response != null) {
            response.setStatus(HttpStatusCode.HTTP_STATUS_CODE_401.getCode());
        }
        return new ServiceResponse<T>(ResultCode.NO_PERMISSION.getRsultMsg(), ResultCode.NO_PERMISSION.getReusltCode());
    }

    public static <T> ServiceResponse<T> getServiceResponse(String msg, int code, T data) {
        return new ServiceResponse<T>(msg, code, data);
    }

    public static <T> ServiceResponse<T> getServiceResponse(String msg, int code) {
        return new ServiceResponse<T>(msg, code);
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

