/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.xml.dom;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.dom.EntityResolverUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class XmlDom4jUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(XmlDom4jUtils.class);

    private XmlDom4jUtils() {
    }

    public static Document getDocument(InputStream inputStream) throws SAXException, DocumentException {
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver(EntityResolverUtils.getNoEntityResolver());
        saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxReader.setFeature("http://xml.org/sax/features/validation", true);
        saxReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        return saxReader.read((InputStream)bis);
    }

    public static Document getDocument(File xmlFile) {
        Document document = null;
        SAXReader saxReader = new SAXReader();
        try (FileInputStream fis = new FileInputStream(xmlFile);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            saxReader.setEntityResolver(EntityResolverUtils.getNoEntityResolver());
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/validation", true);
            document = saxReader.read((InputStream)bis);
        }
        catch (DocumentException ex) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "DocumentException. filename:" + xmlFile.getName(), (Throwable)ex);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "GetDocument error. filename:" + xmlFile.getName());
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "SAXException. filename:" + xmlFile.getName(), (Throwable)e);
        }
        return document;
    }

    public static Document getDocument(String filePath) {
        Document document = null;
        File file = FileUtils.getFile((String[])new String[]{filePath});
        try (FileInputStream fis = FileUtils.openInputStream((File)file);){
            document = XmlDom4jUtils.getDocument(fis);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getDocument error. filename:" + file.getName());
        }
        catch (DocumentException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getDocument error. filename:" + file.getName(), e);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXml(Document document, String filePath) {
        if (document == null || filePath == null) {
            return;
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(document.getXMLEncoding());
        format.setNewLineAfterDeclaration(false);
        File xmlFile = FileUtils.getFile((String[])new String[]{filePath});
        XMLWriter writer = null;
        try {
            if (xmlFile.exists()) {
                boolean isDelete = xmlFile.delete();
                if (!isDelete) {
                    CodeCCUtils.INSTANCE.infoLog(LOGGER, "Delete file fail. filename:" + xmlFile.getName());
                }
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "Delete xmlFile. filename:" + xmlFile.getName());
            }
            writer = new XMLWriter((OutputStream)FileUtils.openOutputStream((File)xmlFile), format);
            writer.write(document);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "WriteXml occur error. filename:" + xmlFile.getName());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "XmlWriter close fail.filename:" + xmlFile.getName());
                }
            }
        }
    }
}

