/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.xml.sax;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXParserUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SAXParserUtils.class);

    public static void parseXml(InputStream is, DefaultHandler handler) throws SAXException {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xr.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xr.setFeature("http://xml.org/sax/features/validation", true);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            InputSource inputSource = new InputSource(is);
            inputSource.setEncoding("UTF-8");
            xr.parse(inputSource);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Sax parser xml, error read InputStream.", (Throwable)e);
        }
    }
}

