/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.certificate.dao;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icslite.certificate.dto.CertificateDo;
import com.huawei.support.icslite.certificate.mapper.CertificateMapper;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public enum CertificateDaoHandler {
    INSTANCE;

    private static final CommonLogger LOG;
    private static final CertificateMapper CERTIFICATE_MAPPER;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;

    public void createTb() {
        try {
            CERTIFICATE_MAPPER.createTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'CERTIFICATE' already exists or create error.", e);
        }
    }

    public CertificateDo getCertificate() {
        return CERTIFICATE_MAPPER.getCertificate();
    }

    public boolean updateCertificate(CertificateDo certificateDo) {
        certificateDo.setLastModifyTime(DateUtils.formatDateToString((Date)new Date(), (DateTimeFormatter)DATE_TIME_FORMATTER));
        return CERTIFICATE_MAPPER.updateCertificate(certificateDo) == 1;
    }

    public boolean addCertificate(CertificateDo certificateDo) {
        certificateDo.setLastModifyTime(DateUtils.formatDateToString((Date)new Date(), (DateTimeFormatter)DATE_TIME_FORMATTER));
        return CERTIFICATE_MAPPER.addCertificate(certificateDo) == 1;
    }

    static {
        LOG = CommonLoggerFactory.getLogger(CertificateDaoHandler.class);
        CERTIFICATE_MAPPER = (CertificateMapper)DbMapperUtils.getMapper(CertificateMapper.class);
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }
}

