/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.huawei.management.AdaptiveHeapMXBean;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import sun.management.ManagementFactoryHelper;
import sun.management.Util;

final class PlatformComponent
extends Enum<PlatformComponent> {
    public static final /* enum */ PlatformComponent CLASS_LOADING = new PlatformComponent("java.lang.management.ClassLoadingMXBean", "java.lang", "ClassLoading", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<ClassLoadingMXBean>(){

        @Override
        public List<ClassLoadingMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getClassLoadingMXBean());
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent COMPILATION = new PlatformComponent("java.lang.management.CompilationMXBean", "java.lang", "Compilation", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<CompilationMXBean>(){

        @Override
        public List<CompilationMXBean> getMXBeans() {
            CompilationMXBean compilationMXBean = ManagementFactoryHelper.getCompilationMXBean();
            if (compilationMXBean == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(compilationMXBean);
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent MEMORY = new PlatformComponent("java.lang.management.MemoryMXBean", "java.lang", "Memory", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<MemoryMXBean>(){

        @Override
        public List<MemoryMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getMemoryMXBean());
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent GARBAGE_COLLECTOR = new PlatformComponent("java.lang.management.GarbageCollectorMXBean", "java.lang", "GarbageCollector", PlatformComponent.keyProperties("name"), false, new MXBeanFetcher<GarbageCollectorMXBean>(){

        @Override
        public List<GarbageCollectorMXBean> getMXBeans() {
            return ManagementFactoryHelper.getGarbageCollectorMXBeans();
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent MEMORY_MANAGER = new PlatformComponent("java.lang.management.MemoryManagerMXBean", "java.lang", "MemoryManager", PlatformComponent.keyProperties("name"), false, new MXBeanFetcher<MemoryManagerMXBean>(){

        @Override
        public List<MemoryManagerMXBean> getMXBeans() {
            return ManagementFactoryHelper.getMemoryManagerMXBeans();
        }
    }, GARBAGE_COLLECTOR);
    public static final /* enum */ PlatformComponent MEMORY_POOL = new PlatformComponent("java.lang.management.MemoryPoolMXBean", "java.lang", "MemoryPool", PlatformComponent.keyProperties("name"), false, new MXBeanFetcher<MemoryPoolMXBean>(){

        @Override
        public List<MemoryPoolMXBean> getMXBeans() {
            return ManagementFactoryHelper.getMemoryPoolMXBeans();
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent OPERATING_SYSTEM = new PlatformComponent("java.lang.management.OperatingSystemMXBean", "java.lang", "OperatingSystem", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<OperatingSystemMXBean>(){

        @Override
        public List<OperatingSystemMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getOperatingSystemMXBean());
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent RUNTIME = new PlatformComponent("java.lang.management.RuntimeMXBean", "java.lang", "Runtime", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<RuntimeMXBean>(){

        @Override
        public List<RuntimeMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getRuntimeMXBean());
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent THREADING = new PlatformComponent("java.lang.management.ThreadMXBean", "java.lang", "Threading", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<ThreadMXBean>(){

        @Override
        public List<ThreadMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getThreadMXBean());
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent LOGGING = new PlatformComponent("java.lang.management.PlatformLoggingMXBean", "java.util.logging", "Logging", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<PlatformLoggingMXBean>(){

        @Override
        public List<PlatformLoggingMXBean> getMXBeans() {
            PlatformLoggingMXBean platformLoggingMXBean = ManagementFactoryHelper.getPlatformLoggingMXBean();
            if (platformLoggingMXBean == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(platformLoggingMXBean);
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent BUFFER_POOL = new PlatformComponent("java.lang.management.BufferPoolMXBean", "java.nio", "BufferPool", PlatformComponent.keyProperties("name"), false, new MXBeanFetcher<BufferPoolMXBean>(){

        @Override
        public List<BufferPoolMXBean> getMXBeans() {
            return ManagementFactoryHelper.getBufferPoolMXBeans();
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent SUN_GARBAGE_COLLECTOR = new PlatformComponent("com.sun.management.GarbageCollectorMXBean", "java.lang", "GarbageCollector", PlatformComponent.keyProperties("name"), false, new MXBeanFetcher<com.sun.management.GarbageCollectorMXBean>(){

        @Override
        public List<com.sun.management.GarbageCollectorMXBean> getMXBeans() {
            return PlatformComponent.getGcMXBeanList(com.sun.management.GarbageCollectorMXBean.class);
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent SUN_OPERATING_SYSTEM = new PlatformComponent("com.sun.management.OperatingSystemMXBean", "java.lang", "OperatingSystem", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<com.sun.management.OperatingSystemMXBean>(){

        @Override
        public List<com.sun.management.OperatingSystemMXBean> getMXBeans() {
            return PlatformComponent.getOSMXBeanList(com.sun.management.OperatingSystemMXBean.class);
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent SUN_UNIX_OPERATING_SYSTEM = new PlatformComponent("com.sun.management.UnixOperatingSystemMXBean", "java.lang", "OperatingSystem", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<UnixOperatingSystemMXBean>(){

        @Override
        public List<UnixOperatingSystemMXBean> getMXBeans() {
            return PlatformComponent.getOSMXBeanList(UnixOperatingSystemMXBean.class);
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent HOTSPOT_DIAGNOSTIC = new PlatformComponent("com.sun.management.HotSpotDiagnosticMXBean", "com.sun.management", "HotSpotDiagnostic", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<HotSpotDiagnosticMXBean>(){

        @Override
        public List<HotSpotDiagnosticMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getDiagnosticMXBean());
        }
    }, new PlatformComponent[0]);
    public static final /* enum */ PlatformComponent ADAPTIVE_HEAP = new PlatformComponent("com.huawei.management.AdaptiveHeapMXBean", "com.huawei.management", "AdaptiveHeap", PlatformComponent.defaultKeyProperties(), true, new MXBeanFetcher<AdaptiveHeapMXBean>(){

        @Override
        public List<AdaptiveHeapMXBean> getMXBeans() {
            return Collections.singletonList(ManagementFactoryHelper.getAdaptiveHeapMXBean());
        }
    }, new PlatformComponent[0]);
    private final String mxbeanInterfaceName;
    private final String domain;
    private final String type;
    private final Set<String> keyProperties;
    private final MXBeanFetcher<?> fetcher;
    private final PlatformComponent[] subComponents;
    private final boolean singleton;
    private static Set<String> defaultKeyProps;
    private static Map<String, PlatformComponent> enumMap;
    private static final long serialVersionUID = 6992337162326171013L;
    private static final /* synthetic */ PlatformComponent[] $VALUES;

    public static PlatformComponent[] values() {
        return (PlatformComponent[])$VALUES.clone();
    }

    public static PlatformComponent valueOf(String string) {
        return Enum.valueOf(PlatformComponent.class, string);
    }

    private static <T extends GarbageCollectorMXBean> List<T> getGcMXBeanList(Class<T> clazz) {
        List<GarbageCollectorMXBean> list = ManagementFactoryHelper.getGarbageCollectorMXBeans();
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (GarbageCollectorMXBean garbageCollectorMXBean : list) {
            if (!clazz.isInstance(garbageCollectorMXBean)) continue;
            arrayList.add(clazz.cast(garbageCollectorMXBean));
        }
        return arrayList;
    }

    private static <T extends OperatingSystemMXBean> List<T> getOSMXBeanList(Class<T> clazz) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactoryHelper.getOperatingSystemMXBean();
        if (clazz.isInstance(operatingSystemMXBean)) {
            return Collections.singletonList(clazz.cast(operatingSystemMXBean));
        }
        return Collections.emptyList();
    }

    private PlatformComponent(String string2, String string3, String string4, Set<String> set, boolean bl, MXBeanFetcher<?> mXBeanFetcher, PlatformComponent ... platformComponentArray) {
        this.mxbeanInterfaceName = string2;
        this.domain = string3;
        this.type = string4;
        this.keyProperties = set;
        this.singleton = bl;
        this.fetcher = mXBeanFetcher;
        this.subComponents = platformComponentArray;
    }

    private static Set<String> defaultKeyProperties() {
        if (defaultKeyProps == null) {
            defaultKeyProps = Collections.singleton("type");
        }
        return defaultKeyProps;
    }

    private static Set<String> keyProperties(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("type");
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return hashSet;
    }

    boolean isSingleton() {
        return this.singleton;
    }

    String getMXBeanInterfaceName() {
        return this.mxbeanInterfaceName;
    }

    Class<? extends PlatformManagedObject> getMXBeanInterface() {
        try {
            return Class.forName(this.mxbeanInterfaceName, false, PlatformManagedObject.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    <T extends PlatformManagedObject> List<T> getMXBeans(Class<T> clazz) {
        return this.fetcher.getMXBeans();
    }

    <T extends PlatformManagedObject> T getSingletonMXBean(Class<T> clazz) {
        if (!this.singleton) {
            throw new IllegalArgumentException(this.mxbeanInterfaceName + " can have zero or more than one instances");
        }
        List<T> list = this.getMXBeans(clazz);
        assert (list.size() == 1);
        return (T)(list.isEmpty() ? null : (PlatformManagedObject)list.get(0));
    }

    <T extends PlatformManagedObject> T getSingletonMXBean(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        if (!this.singleton) {
            throw new IllegalArgumentException(this.mxbeanInterfaceName + " can have zero or more than one instances");
        }
        assert (this.keyProperties.size() == 1);
        String string = this.domain + ":type=" + this.type;
        return (T)((PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, string, clazz));
    }

    <T extends PlatformManagedObject> List<T> getMXBeans(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (ObjectName objectName : this.getObjectNames(mBeanServerConnection)) {
            arrayList.add(ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName.getCanonicalName(), clazz));
        }
        return arrayList;
    }

    private Set<ObjectName> getObjectNames(MBeanServerConnection mBeanServerConnection) throws IOException {
        String string = this.domain + ":type=" + this.type;
        if (this.keyProperties.size() > 1) {
            string = string + ",*";
        }
        ObjectName objectName = Util.newObjectName(string);
        Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
        for (PlatformComponent platformComponent : this.subComponents) {
            set.addAll(platformComponent.getObjectNames(mBeanServerConnection));
        }
        return set;
    }

    private static synchronized void ensureInitialized() {
        if (enumMap == null) {
            enumMap = new HashMap<String, PlatformComponent>();
            for (PlatformComponent platformComponent : PlatformComponent.values()) {
                enumMap.put(platformComponent.getMXBeanInterfaceName(), platformComponent);
            }
        }
    }

    static boolean isPlatformMXBean(String string) {
        PlatformComponent.ensureInitialized();
        return enumMap.containsKey(string);
    }

    static <T extends PlatformManagedObject> PlatformComponent getPlatformComponent(Class<T> clazz) {
        PlatformComponent.ensureInitialized();
        String string = clazz.getName();
        PlatformComponent platformComponent = enumMap.get(string);
        if (platformComponent != null && platformComponent.getMXBeanInterface() == clazz) {
            return platformComponent;
        }
        return null;
    }

    static {
        $VALUES = new PlatformComponent[]{CLASS_LOADING, COMPILATION, MEMORY, GARBAGE_COLLECTOR, MEMORY_MANAGER, MEMORY_POOL, OPERATING_SYSTEM, RUNTIME, THREADING, LOGGING, BUFFER_POOL, SUN_GARBAGE_COLLECTOR, SUN_OPERATING_SYSTEM, SUN_UNIX_OPERATING_SYSTEM, HOTSPOT_DIAGNOSTIC, ADAPTIVE_HEAP};
    }

    static interface MXBeanFetcher<T extends PlatformManagedObject> {
        public List<T> getMXBeans();
    }
}

