/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import sun.security.util.Debug;

public class SecureClassLoader
extends ClassLoader {
    private final boolean initialized;
    private final HashMap<CodeSource, ProtectionDomain> pdcache = new HashMap(11);
    private static final Debug debug = Debug.getInstance("scl");

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected SecureClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        return this.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, CodeSource codeSource) {
        return this.defineClass(string, byteBuffer, this.getProtectionDomain(codeSource));
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        this.check();
        return new Permissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        ProtectionDomain protectionDomain = null;
        HashMap<CodeSource, ProtectionDomain> hashMap = this.pdcache;
        synchronized (hashMap) {
            protectionDomain = this.pdcache.get(codeSource);
            if (protectionDomain == null) {
                PermissionCollection permissionCollection = this.getPermissions(codeSource);
                protectionDomain = new ProtectionDomain(codeSource, permissionCollection, this, null);
                this.pdcache.put(codeSource, protectionDomain);
                if (debug != null) {
                    debug.println(" getPermissions " + protectionDomain);
                    debug.println("");
                }
            }
        }
        return protectionDomain;
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

