/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.util.DerValue;

class KeyImpl
implements SecretKey,
Destroyable,
Serializable {
    private static final long serialVersionUID = -7889313790214321193L;
    private transient byte[] keyBytes;
    private transient int keyType;
    private volatile transient boolean destroyed = false;

    public KeyImpl(byte[] byArray, int n) {
        this.keyBytes = (byte[])byArray.clone();
        this.keyType = n;
    }

    public KeyImpl(KerberosPrincipal kerberosPrincipal, char[] cArray, String string) {
        try {
            PrincipalName principalName = new PrincipalName(kerberosPrincipal.getName());
            EncryptionKey encryptionKey = new EncryptionKey(cArray, principalName.getSalt(), string);
            this.keyBytes = encryptionKey.getBytes();
            this.keyType = encryptionKey.getEType();
        }
        catch (KrbException krbException) {
            throw new IllegalArgumentException(krbException.getMessage());
        }
    }

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.keyType;
    }

    @Override
    public final String getAlgorithm() {
        return this.getAlgorithmName(this.keyType);
    }

    private String getAlgorithmName(int n) {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        switch (n) {
            case 1: 
            case 3: {
                return "DES";
            }
            case 16: {
                return "DESede";
            }
            case 23: {
                return "ArcFourHmac";
            }
            case 17: {
                return "AES128";
            }
            case 18: {
                return "AES256";
            }
            case 19: {
                return "aes128-cts-hmac-sha256-128";
            }
            case 20: {
                return "aes256-cts-hmac-sha384-192";
            }
            case 0: {
                return "NULL";
            }
        }
        throw new IllegalArgumentException("Unsupported encryption type: " + n);
    }

    @Override
    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return "RAW";
    }

    @Override
    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return (byte[])this.keyBytes.clone();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            Arrays.fill(this.keyBytes, (byte)0);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.destroyed) {
            throw new IOException("This key is no longer valid");
        }
        try {
            objectOutputStream.writeObject(new EncryptionKey(this.keyType, this.keyBytes).asn1Encode());
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            EncryptionKey encryptionKey = new EncryptionKey(new DerValue((byte[])objectInputStream.readObject()));
            this.keyType = encryptionKey.getEType();
            this.keyBytes = encryptionKey.getBytes();
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "EncryptionKey: keyType=" + this.keyType + " keyBytes (hex dump)=" + (this.keyBytes == null || this.keyBytes.length == 0 ? " Empty Key" : '\n' + hexDumpEncoder.encodeBuffer(this.keyBytes) + '\n');
    }

    public int hashCode() {
        int n = 17;
        if (this.isDestroyed()) {
            return n;
        }
        n = 37 * n + Arrays.hashCode(this.keyBytes);
        return 37 * n + this.keyType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyImpl)) {
            return false;
        }
        KeyImpl keyImpl = (KeyImpl)object;
        if (this.isDestroyed() || keyImpl.isDestroyed()) {
            return false;
        }
        return this.keyType == keyImpl.getKeyType() && Arrays.equals(this.keyBytes, keyImpl.getEncoded());
    }
}

