/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.Crc32CksumType;
import sun.security.krb5.internal.crypto.DesMacCksumType;
import sun.security.krb5.internal.crypto.DesMacKCksumType;
import sun.security.krb5.internal.crypto.HmacMd5ArcFourCksumType;
import sun.security.krb5.internal.crypto.HmacSha1Aes128CksumType;
import sun.security.krb5.internal.crypto.HmacSha1Aes256CksumType;
import sun.security.krb5.internal.crypto.HmacSha1Des3KdCksumType;
import sun.security.krb5.internal.crypto.HmacSha2Aes128CksumType;
import sun.security.krb5.internal.crypto.HmacSha2Aes256CksumType;
import sun.security.krb5.internal.crypto.RsaMd5CksumType;
import sun.security.krb5.internal.crypto.RsaMd5DesCksumType;

public abstract class CksumType {
    private static boolean DEBUG = Krb5.DEBUG;

    public static CksumType getInstance(int n) throws KdcErrException {
        CksumType cksumType = null;
        String string = null;
        switch (n) {
            case 1: {
                cksumType = new Crc32CksumType();
                string = "sun.security.krb5.internal.crypto.Crc32CksumType";
                break;
            }
            case 4: {
                cksumType = new DesMacCksumType();
                string = "sun.security.krb5.internal.crypto.DesMacCksumType";
                break;
            }
            case 5: {
                cksumType = new DesMacKCksumType();
                string = "sun.security.krb5.internal.crypto.DesMacKCksumType";
                break;
            }
            case 7: {
                cksumType = new RsaMd5CksumType();
                string = "sun.security.krb5.internal.crypto.RsaMd5CksumType";
                break;
            }
            case 8: {
                cksumType = new RsaMd5DesCksumType();
                string = "sun.security.krb5.internal.crypto.RsaMd5DesCksumType";
                break;
            }
            case 12: {
                cksumType = new HmacSha1Des3KdCksumType();
                string = "sun.security.krb5.internal.crypto.HmacSha1Des3KdCksumType";
                break;
            }
            case 15: {
                cksumType = new HmacSha1Aes128CksumType();
                string = "sun.security.krb5.internal.crypto.HmacSha1Aes128CksumType";
                break;
            }
            case 16: {
                cksumType = new HmacSha1Aes256CksumType();
                string = "sun.security.krb5.internal.crypto.HmacSha1Aes256CksumType";
                break;
            }
            case 19: {
                cksumType = new HmacSha2Aes128CksumType();
                string = "sun.security.krb5.internal.crypto.HmacSha2Aes128CksumType";
                break;
            }
            case 20: {
                cksumType = new HmacSha2Aes256CksumType();
                string = "sun.security.krb5.internal.crypto.HmacSha2Aes256CksumType";
                break;
            }
            case -138: {
                cksumType = new HmacMd5ArcFourCksumType();
                string = "sun.security.krb5.internal.crypto.HmacMd5ArcFourCksumType";
                break;
            }
            default: {
                throw new KdcErrException(15);
            }
        }
        if (DEBUG) {
            System.out.println(">>> CksumType: " + string);
        }
        return cksumType;
    }

    public abstract int confounderSize();

    public abstract int cksumType();

    public abstract boolean isKeyed();

    public abstract int cksumSize();

    public abstract int keyType();

    public abstract int keySize();

    public abstract byte[] calculateChecksum(byte[] var1, int var2, byte[] var3, int var4) throws KrbCryptoException;

    public abstract boolean verifyChecksum(byte[] var1, int var2, byte[] var3, byte[] var4, int var5) throws KrbCryptoException;

    public static boolean isChecksumEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null && byArray2 != null || byArray != null && byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

