/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.KeyUsage;
import sun.security.krb5.internal.crypto.dk.DkCrypto;

public class AesSha2DkCrypto
extends DkCrypto {
    private static final boolean debug = false;
    private static final int BLOCK_SIZE = 16;
    private static final int DEFAULT_ITERATION_COUNT = 32768;
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] ETYPE_NAME_128 = "aes128-cts-hmac-sha256-128".getBytes();
    private static final byte[] ETYPE_NAME_256 = "aes256-cts-hmac-sha384-192".getBytes();
    private final int hashSize;
    private final int keyLength;

    public AesSha2DkCrypto(int n) {
        this.keyLength = n;
        this.hashSize = (n == 128 ? 128 : 192) / 8;
    }

    @Override
    protected int getKeySeedLength() {
        return this.keyLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] stringToKey(char[] cArray, String string, byte[] byArray) throws GeneralSecurityException {
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
            byte[] byArray3 = this.stringToKey(cArray, byArray2, byArray);
            return byArray3;
        }
        catch (Exception exception) {
            byte[] byArray4 = null;
            return byArray4;
        }
        finally {
            if (byArray2 != null) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
    }

    private byte[] stringToKey(char[] cArray, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = 32768;
        if (byArray2 != null) {
            if (byArray2.length != 4) {
                throw new RuntimeException("Invalid parameter to stringToKey");
            }
            n = AesSha2DkCrypto.readBigEndian(byArray2, 0, 4);
        }
        byte[] byArray3 = new byte[27 + byArray.length];
        if (this.keyLength == 128) {
            System.arraycopy(ETYPE_NAME_128, 0, byArray3, 0, 26);
        } else {
            System.arraycopy(ETYPE_NAME_256, 0, byArray3, 0, 26);
        }
        System.arraycopy(byArray, 0, byArray3, 27, byArray.length);
        byte[] byArray4 = this.randomToKey(AesSha2DkCrypto.PBKDF2(cArray, byArray3, n, this.getKeySeedLength()));
        byte[] byArray5 = this.dk(byArray4, KERBEROS_CONSTANT);
        return byArray5;
    }

    @Override
    protected byte[] randomToKey(byte[] byArray) {
        return byArray;
    }

    @Override
    protected byte[] dr(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        byte by;
        byte[] byArray3 = new byte[byArray2.length + 9];
        byArray3[3] = 1;
        System.arraycopy(byArray2, 0, byArray3, 4, byArray2.length);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        Mac mac = Mac.getInstance(this.keyLength == 128 ? "HmacSHA256" : "HmacSHA384");
        mac.init(secretKeySpec);
        int n = this.keyLength == 128 ? 128 : ((by = byArray2[byArray2.length - 1]) == -103 || by == 85 ? 192 : 256);
        byArray3[byArray3.length - 1] = (byte)n;
        byArray3[byArray3.length - 2] = (byte)(n / 256);
        byte[] byArray4 = mac.doFinal(byArray3);
        return Arrays.copyOf(byArray4, n / 8);
    }

    @Override
    protected Cipher getCipher(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        if (byArray2 == null) {
            byArray2 = ZERO_IV;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
        cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    @Override
    public int getChecksumLength() {
        return this.hashSize;
    }

    @Override
    protected byte[] getHmac(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        Mac mac = Mac.getInstance(this.keyLength == 128 ? "HmacSHA256" : "HmacSHA384");
        mac.init(secretKeySpec);
        byte[] byArray3 = mac.doFinal(byArray2);
        byte[] byArray4 = new byte[this.hashSize];
        System.arraycopy(byArray3, 0, byArray4, 0, this.hashSize);
        return byArray4;
    }

    private byte[] deriveKey(byte[] byArray, int n, byte by) throws GeneralSecurityException {
        byte[] byArray2 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), by};
        return this.dk(byArray, byArray2);
    }

    @Override
    public byte[] calculateChecksum(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray3 = this.deriveKey(byArray, n, (byte)-103);
        try {
            byte[] byArray4 = this.getHmac(byArray3, byArray2);
            if (byArray4.length == this.getChecksumLength()) {
                byte[] byArray5 = byArray4;
                return byArray5;
            }
            if (byArray4.length > this.getChecksumLength()) {
                byte[] byArray6 = new byte[this.getChecksumLength()];
                System.arraycopy(byArray4, 0, byArray6, 0, byArray6.length);
                byte[] byArray7 = byArray6;
                return byArray7;
            }
            throw new GeneralSecurityException("checksum size too short: " + byArray4.length + "; expecting : " + this.getChecksumLength());
        }
        finally {
            Arrays.fill(byArray3, 0, byArray3.length, (byte)0);
        }
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray5 = this.encryptCTS(byArray, n, byArray2, byArray3, byArray4, n2, n3, true);
        return byArray5;
    }

    @Override
    public byte[] encryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = this.encryptCTS(byArray, n, byArray2, null, byArray3, n2, n3, false);
        return byArray4;
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = this.decryptCTS(byArray, n, byArray2, byArray3, n2, n3, true);
        return byArray4;
    }

    @Override
    public byte[] decryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = this.decryptCTS(byArray, n, byArray2, byArray3, n2, n3, false);
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encryptCTS(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3, boolean bl) throws GeneralSecurityException, KrbCryptoException {
        byte[] byArray5;
        byte[] byArray6;
        block7: {
            byte[] byArray7 = null;
            byArray6 = null;
            try {
                byte[] byArray8;
                byArray7 = this.deriveKey(byArray, n, (byte)-86);
                byte[] byArray9 = null;
                if (bl) {
                    byArray8 = Confounder.bytes(16);
                    byArray9 = new byte[byArray8.length + n3];
                    System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
                    System.arraycopy(byArray4, n2, byArray9, byArray8.length, n3);
                } else {
                    byArray9 = new byte[n3];
                    System.arraycopy(byArray4, n2, byArray9, 0, n3);
                }
                byArray8 = new byte[byArray9.length + this.hashSize];
                Cipher cipher = Cipher.getInstance("AES/CTS/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray7, "AES");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                cipher.doFinal(byArray9, 0, byArray9.length, byArray8);
                byArray6 = this.deriveKey(byArray, n, (byte)85);
                byte[] byArray10 = Arrays.copyOf(byArray2, byArray2.length + byArray9.length);
                System.arraycopy(byArray8, 0, byArray10, byArray2.length, byArray9.length);
                byte[] byArray11 = this.getHmac(byArray6, byArray10);
                System.arraycopy(byArray11, 0, byArray8, byArray9.length, byArray11.length);
                byArray5 = byArray8;
                if (byArray7 == null) break block7;
            }
            catch (Throwable throwable) {
                if (byArray7 != null) {
                    Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
                }
                if (byArray6 != null) {
                    Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
        }
        if (byArray6 != null) {
            Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
        }
        return byArray5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decryptCTS(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3, boolean bl) throws GeneralSecurityException {
        byte[] byArray4;
        byte[] byArray5;
        block12: {
            byte[] byArray6;
            byte[] byArray7;
            block10: {
                byte[] byArray8;
                block11: {
                    byArray7 = null;
                    byArray5 = null;
                    try {
                        byArray7 = this.deriveKey(byArray, n, (byte)-86);
                        Cipher cipher = Cipher.getInstance("AES/CTS/NoPadding");
                        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray7, "AES");
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
                        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                        byArray6 = cipher.doFinal(byArray3, n2, n3 - this.hashSize);
                        byArray5 = this.deriveKey(byArray, n, (byte)85);
                        byte[] byArray9 = Arrays.copyOf(byArray2, byArray2.length + n3 - this.hashSize);
                        System.arraycopy(byArray3, n2, byArray9, byArray2.length, n3 - this.hashSize);
                        byte[] byArray10 = this.getHmac(byArray5, byArray9);
                        int n4 = n2 + n3 - this.hashSize;
                        boolean bl2 = false;
                        if (byArray10.length >= this.hashSize) {
                            for (int i = 0; i < this.hashSize; ++i) {
                                if (byArray10[i] == byArray3[n4 + i]) continue;
                                bl2 = true;
                                break;
                            }
                        }
                        if (bl2) {
                            throw new GeneralSecurityException("Checksum failed");
                        }
                        if (!bl) break block10;
                        byte[] byArray11 = new byte[byArray6.length - 16];
                        System.arraycopy(byArray6, 16, byArray11, 0, byArray11.length);
                        byArray8 = byArray11;
                        if (byArray7 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (byArray7 != null) {
                            Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
                        }
                        if (byArray5 != null) {
                            Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
                        }
                        throw throwable;
                    }
                    Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
                }
                if (byArray5 != null) {
                    Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
                }
                return byArray8;
            }
            byArray4 = byArray6;
            if (byArray7 == null) break block12;
            Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
        }
        if (byArray5 != null) {
            Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
        }
        return byArray4;
    }

    private static byte[] PBKDF2(char[] cArray, byte[] byArray, int n, int n2) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n, n2);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(n2 == 128 ? "PBKDF2WithHmacSHA256" : "PBKDF2WithHmacSHA384");
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        byte[] byArray2 = secretKey.getEncoded();
        return byArray2;
    }

    public static final int readBigEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = (n2 - 1) * 8;
        while (n2 > 0) {
            n3 += (byArray[n] & 0xFF) << n4;
            n4 -= 8;
            ++n;
            --n2;
        }
        return n3;
    }
}

