/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import sun.security.action.GetPropertyAction;
import sun.security.provider.NativePRNG;

public final class SunEntries {
    public static final String DEF_SECURE_RANDOM_ALGO;
    private LinkedHashSet<Provider.Service> services = new LinkedHashSet(50, 0.9f);
    private static final String PROP_EGD = "java.security.egd";
    private static final String PROP_RNDSOURCE = "securerandom.source";
    private static final boolean useLegacyDSA;
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";
    private static final String seedSource;

    public static List<String> createAliases(String ... stringArray) {
        return Arrays.asList(stringArray);
    }

    public static List<String> createAliasesWithOid(String ... stringArray) {
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length + 1);
        stringArray2[stringArray2.length - 1] = "OID." + stringArray[0];
        return Arrays.asList(stringArray2);
    }

    SunEntries(Provider provider) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        if (NativePRNG.isAvailable()) {
            this.add(provider, "SecureRandom", "NativePRNG", "sun.security.provider.NativePRNG", null, hashMap);
        }
        if (NativePRNG.Blocking.isAvailable()) {
            this.add(provider, "SecureRandom", "NativePRNGBlocking", "sun.security.provider.NativePRNG$Blocking", null, hashMap);
        }
        if (NativePRNG.NonBlocking.isAvailable()) {
            this.add(provider, "SecureRandom", "NativePRNGNonBlocking", "sun.security.provider.NativePRNG$NonBlocking", null, hashMap);
        }
        hashMap.put("ImplementedIn", "Software");
        this.add(provider, "SecureRandom", "SHA1PRNG", "sun.security.provider.SecureRandom", null, hashMap);
        hashMap.clear();
        String string = "java.security.interfaces.DSAPublicKey|java.security.interfaces.DSAPrivateKey";
        hashMap.put("SupportedKeyClasses", string);
        hashMap.put("ImplementedIn", "Software");
        hashMap.put("KeySize", "1024");
        this.add(provider, "Signature", "SHA1withDSA", "sun.security.provider.DSA$SHA1withDSA", SunEntries.createAliasesWithOid("1.2.840.10040.4.3", "DSA", "DSS", "SHA/DSA", "SHA-1/DSA", "SHA1/DSA", "SHAwithDSA", "DSAWithSHA1", "1.3.14.3.2.13", "1.3.14.3.2.27"), hashMap);
        this.add(provider, "Signature", "NONEwithDSA", "sun.security.provider.DSA$RawDSA", SunEntries.createAliases("RawDSA"), hashMap);
        hashMap.put("KeySize", "2048");
        this.add(provider, "Signature", "SHA224withDSA", "sun.security.provider.DSA$SHA224withDSA", SunEntries.createAliasesWithOid("2.16.840.1.101.3.4.3.1"), hashMap);
        this.add(provider, "Signature", "SHA256withDSA", "sun.security.provider.DSA$SHA256withDSA", SunEntries.createAliasesWithOid("2.16.840.1.101.3.4.3.2"), hashMap);
        hashMap.remove("KeySize");
        hashMap.clear();
        hashMap.put("ImplementedIn", "Software");
        hashMap.put("KeySize", "2048");
        String string2 = "1.2.840.10040.4.1";
        List<String> list = SunEntries.createAliasesWithOid(string2, "1.3.14.3.2.12");
        String string3 = "sun.security.provider.DSAKeyPairGenerator$";
        string3 = string3 + (useLegacyDSA ? "Legacy" : "Current");
        this.add(provider, "KeyPairGenerator", "DSA", string3, list, hashMap);
        this.add(provider, "AlgorithmParameterGenerator", "DSA", "sun.security.provider.DSAParameterGenerator", list, hashMap);
        hashMap.remove("KeySize");
        this.add(provider, "AlgorithmParameters", "DSA", "sun.security.provider.DSAParameters", list, hashMap);
        this.add(provider, "KeyFactory", "DSA", "sun.security.provider.DSAKeyFactory", list, hashMap);
        this.add(provider, "MessageDigest", "MD2", "sun.security.provider.MD2", null, hashMap);
        this.add(provider, "MessageDigest", "MD5", "sun.security.provider.MD5", null, hashMap);
        this.add(provider, "MessageDigest", "SHA", "sun.security.provider.SHA", SunEntries.createAliasesWithOid("1.3.14.3.2.26", "SHA-1", "SHA1"), hashMap);
        String string4 = "2.16.840.1.101.3.4.2";
        this.add(provider, "MessageDigest", "SHA-224", "sun.security.provider.SHA2$SHA224", SunEntries.createAliasesWithOid(string4 + ".4"), hashMap);
        this.add(provider, "MessageDigest", "SHA-256", "sun.security.provider.SHA2$SHA256", SunEntries.createAliasesWithOid(string4 + ".1"), hashMap);
        this.add(provider, "MessageDigest", "SHA-384", "sun.security.provider.SHA5$SHA384", SunEntries.createAliasesWithOid(string4 + ".2"), hashMap);
        this.add(provider, "MessageDigest", "SHA-512", "sun.security.provider.SHA5$SHA512", SunEntries.createAliasesWithOid(string4 + ".3"), hashMap);
        this.add(provider, "MessageDigest", "SHA-512/224", "sun.security.provider.SHA5$SHA512_224", SunEntries.createAliasesWithOid(string4 + ".5"), hashMap);
        this.add(provider, "MessageDigest", "SHA-512/256", "sun.security.provider.SHA5$SHA512_256", SunEntries.createAliasesWithOid(string4 + ".6"), hashMap);
        this.add(provider, "CertificateFactory", "X.509", "sun.security.provider.X509Factory", SunEntries.createAliases("X509"), hashMap);
        this.add(provider, "KeyStore", "JKS", "sun.security.provider.JavaKeyStore$DualFormatJKS", null, hashMap);
        this.add(provider, "KeyStore", "CaseExactJKS", "sun.security.provider.JavaKeyStore$CaseExactJKS", null, hashMap);
        this.add(provider, "KeyStore", "DKS", "sun.security.provider.DomainKeyStore$DKS", null, hashMap);
        hashMap.put("LDAPSchema", "RFC2587");
        this.add(provider, "CertStore", "LDAP", "sun.security.provider.certpath.ldap.LDAPCertStore", null, hashMap);
        hashMap.remove("LDAPSchema");
        this.add(provider, "CertStore", "Collection", "sun.security.provider.certpath.CollectionCertStore", null, hashMap);
        this.add(provider, "CertStore", "com.sun.security.IndexedCollection", "sun.security.provider.certpath.IndexedCollectionCertStore", null, hashMap);
        this.add(provider, "Policy", "JavaPolicy", "sun.security.provider.PolicySpiFile", null, null);
        this.add(provider, "Configuration", "JavaLoginConfig", "sun.security.provider.ConfigFile$Spi", null, null);
        hashMap.clear();
        hashMap.put("ValidationAlgorithm", "RFC5280");
        hashMap.put("ImplementedIn", "Software");
        this.add(provider, "CertPathBuilder", "PKIX", "sun.security.provider.certpath.SunCertPathBuilder", null, hashMap);
        this.add(provider, "CertPathValidator", "PKIX", "sun.security.provider.certpath.PKIXCertPathValidator", null, hashMap);
    }

    Iterator<Provider.Service> iterator() {
        return this.services.iterator();
    }

    private void add(Provider provider, String string, String string2, String string3, List<String> list, HashMap<String, String> hashMap) {
        this.services.add(new Provider.Service(provider, string, string2, string3, list, hashMap));
    }

    static String getSeedSource() {
        return seedSource;
    }

    static File getDeviceFile(URL uRL) throws IOException {
        try {
            URI uRI = uRL.toURI();
            if (uRI.isOpaque()) {
                URI uRI2 = new File(System.getProperty("user.dir")).toURI();
                String string = uRI2.toString() + uRI.toString().substring(5);
                return new File(URI.create(string));
            }
            return new File(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
    }

    static {
        useLegacyDSA = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty("jdk.security.legacyDSAKeyPairGenerator"));
        seedSource = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string = System.getProperty(SunEntries.PROP_EGD, "");
                if (string.length() != 0) {
                    return string;
                }
                string = Security.getProperty(SunEntries.PROP_RNDSOURCE);
                if (string == null) {
                    return "";
                }
                return string;
            }
        });
        DEF_SECURE_RANDOM_ALGO = NativePRNG.isAvailable() && (seedSource.equals(URL_DEV_URANDOM) || seedSource.equals(URL_DEV_RANDOM)) ? "NativePRNG" : "SHA1PRNG";
    }
}

