/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sun.security.util.AlgorithmDecomposer;

public abstract class AbstractAlgorithmConstraints
implements AlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    protected AbstractAlgorithmConstraints(AlgorithmDecomposer algorithmDecomposer) {
        this.decomposer = algorithmDecomposer;
    }

    static List<String> getAlgorithms(final String string) {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(string);
            }
        });
        String[] stringArray = null;
        if (string2 != null && !string2.isEmpty()) {
            if (string2.length() >= 2 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        if (stringArray == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(stringArray));
    }

    static boolean checkAlgorithm(Set<String> set, String string, AlgorithmDecomposer algorithmDecomposer) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        Set<String> set2 = null;
        if (set.contains(string.toLowerCase())) {
            return false;
        }
        if (set2 == null) {
            set2 = algorithmDecomposer.decompose(string);
        }
        for (String string2 : set2) {
            if (!set.contains(string2.toLowerCase())) continue;
            return false;
        }
        return true;
    }
}

