/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.core;

import java.io.IOException;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.EncryptionException;

public final class HWHttpUtilities {
    private HWHttpUtilities() {
    }

    public static boolean isSecureChannel(HttpServletRequest request) {
        try {
            ESAPI.httpUtilities().assertSecureChannel(request);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean isSecureRequest(HttpServletRequest request) {
        try {
            ESAPI.httpUtilities().assertSecureRequest(request);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        String receivedMethod = request.getMethod();
        String requiredMethod = "POST";
        return receivedMethod.equals(requiredMethod);
    }

    public static HttpSession changeSessionIdentifier(HttpServletRequest request) throws AuthenticationException {
        return ESAPI.httpUtilities().changeSessionIdentifier(request);
    }

    public static String decryptHiddenField(String encrypted, SecretKey key) {
        return ESAPI.httpUtilities().decryptHiddenField(encrypted, key);
    }

    public static String encryptHiddenField(String value, SecretKey key) throws EncryptionException {
        return ESAPI.httpUtilities().encryptHiddenField(value, key);
    }

    public static String encryptQueryString(String query, SecretKey key) throws EncryptionException {
        return ESAPI.httpUtilities().encryptQueryString(query, key);
    }

    public static Map<String, String> decryptQueryString(String encrypted, SecretKey key) throws EncryptionException {
        return ESAPI.httpUtilities().decryptQueryString(encrypted, key);
    }

    public static Map<String, String> decryptStateFromCookie(HttpServletRequest request, SecretKey key) throws EncryptionException {
        return ESAPI.httpUtilities().decryptStateFromCookie(request, key);
    }

    public static void encryptStateInCookie(HttpServletResponse response, Map<String, String> cleartext, SecretKey key) throws EncryptionException {
        ESAPI.httpUtilities().encryptStateInCookie(response, cleartext, key);
    }

    public static void sendRedirect(HttpServletResponse response, String location) throws AccessControlException, IOException {
        ESAPI.httpUtilities().sendRedirect(response, location);
    }
}

