/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import java.util.HashSet;

public class RegexCharSet
extends HashSet<Character> {
    private static final long serialVersionUID = -7346678370206989640L;

    public RegexCharSet(int initialCapacity) {
        super(initialCapacity);
    }

    public static RegexCharSet clone(String chs) {
        RegexCharSet set = new RegexCharSet(chs.length());
        for (int i = 0; i < chs.length(); ++i) {
            set.add(Character.valueOf(chs.charAt(i)));
        }
        return set;
    }

    public static RegexCharSet clone(char from, char to) {
        if (to < from) {
            throw new IllegalArgumentException();
        }
        RegexCharSet set = new RegexCharSet(to - from + 1);
        for (int i = from; i <= to; ++i) {
            set.add(Character.valueOf((char)i));
        }
        return set;
    }

    public static RegexCharSet digitSet() {
        return RegexCharSet.clone('0', '9');
    }

    public static RegexCharSet wordSet() {
        RegexCharSet wordSet = RegexCharSet.digitSet();
        wordSet.addAll(RegexCharSet.clone('A', 'Z'));
        wordSet.addAll(RegexCharSet.clone('a', 'z'));
        wordSet.add(Character.valueOf('_'));
        return wordSet;
    }

    public static RegexCharSet lineBreakSet() {
        return RegexCharSet.clone("\r\n");
    }

    public static RegexCharSet whiteSpaceSet() {
        return RegexCharSet.clone(" \t\r\n\f\u000b\u001c\u001d\u001f\u001e");
    }

    public RegexCharSet reversed() {
        RegexCharSet reverse = new RegexCharSet(128 - this.size());
        for (int i = 0; i < 128; ++i) {
            if (this.contains(Character.valueOf((char)i))) continue;
            reverse.add(Character.valueOf((char)i));
        }
        return reverse;
    }
}

