/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.header.readers;

import com.huawei.springframework.security.header.readers.BadHeaderException;
import com.huawei.springframework.security.header.readers.HeaderReader;
import com.huawei.springframework.security.web.access.DefaultAccessDeniedHandlerImpl;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.web.filter.OncePerRequestFilter;

public final class HeaderReaderFilter
extends OncePerRequestFilter {
    private AccessDeniedHandler accessDeniedHandler = new DefaultAccessDeniedHandlerImpl();
    private HeaderReader reader = null;

    public HeaderReaderFilter(HeaderReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("The HeaderReader is null for constructing HeaderReaderFilter.");
        }
        this.reader = reader;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            this.reader.readHeader(request, response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (BadHeaderException ex) {
            this.accessDeniedHandler.handle(request, response, (AccessDeniedException)ex);
        }
    }

    public void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.accessDeniedHandler = accessDeniedHandler;
    }
}

