/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.header.readers;

import com.huawei.springframework.security.web.util.EmptyUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class OverrideAddHeaderResponseWrapper
extends HttpServletResponseWrapper {
    private static final String RESPONSE_HEADER_SPLIT = "#;#";
    private Set<String> noDuplicateResponseHeaderSet = new HashSet<String>();

    public OverrideAddHeaderResponseWrapper(HttpServletResponse response, String noDuplicateResponseHeader) {
        super(response);
        if (EmptyUtils.hasText(noDuplicateResponseHeader)) {
            String[] keys;
            for (String key : keys = noDuplicateResponseHeader.split(RESPONSE_HEADER_SPLIT)) {
                this.noDuplicateResponseHeaderSet.add(key.trim().toLowerCase(Locale.ENGLISH));
            }
        } else {
            this.noDuplicateResponseHeaderSet = Collections.emptySet();
        }
    }

    public void addHeader(String name, String value) {
        if (EmptyUtils.isEmpty(name)) {
            return;
        }
        if ("X-XSS-Protection".equalsIgnoreCase(name) || "X-Frame-Options".equalsIgnoreCase(name) || "X-Content-Type-Options".equalsIgnoreCase(name) || "Strict-Transport-Security".equalsIgnoreCase(name) || this.noDuplicateResponseHeaderSet.contains(name.toLowerCase(Locale.ENGLISH))) {
            super.setHeader(name, value);
        } else {
            super.addHeader(name, value);
        }
    }
}

