/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.header.readers;

import com.huawei.springframework.security.header.readers.BadHeaderException;
import com.huawei.springframework.security.header.readers.HeaderReader;
import com.huawei.springframework.security.web.util.LogUtils;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.net.URI;
import java.util.Enumeration;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMatcherHeaderCheckReader
implements HeaderReader {
    private static final Logger LOG = LoggerFactory.getLogger(RequestMatcherHeaderCheckReader.class);
    private boolean blackListCheck = true;
    private String header = null;
    private String pattern = null;
    private boolean sameDomain = false;
    private Pattern valuePattern = null;

    @Override
    public void readHeader(HttpServletRequest request, HttpServletResponse response) {
        if (this.header == null) {
            return;
        }
        Enumeration headers = request.getHeaders(this.header);
        while (headers.hasMoreElements()) {
            String headerValue = (String)headers.nextElement();
            if (!this.sameDomain) {
                this.dealFailResult(headerValue);
                continue;
            }
            URI uri = URI.create(headerValue);
            String domain = uri.getHost();
            if (domain != null) {
                String serverDomain;
                domain = domain.replaceAll(".*\\.(?=.*\\.)", "").toLowerCase(Locale.ENGLISH);
                String string = serverDomain = this.pattern == null ? RequestUtils.getServerName((ServletRequest)request).replaceAll(".*\\.(?=.*\\.)", "").toLowerCase(Locale.ENGLISH) : this.pattern.replaceAll(".*\\.(?=.*\\.)", "").toLowerCase(Locale.ENGLISH);
                if (domain.equals(serverDomain)) continue;
            }
            this.processHeaderCheckingFail(headerValue);
        }
    }

    private void dealFailResult(String headerValue) {
        if (this.blackListCheck && this.valuePattern.matcher(headerValue).matches()) {
            this.processHeaderCheckingFail(headerValue);
        }
        if (!this.blackListCheck && !this.valuePattern.matcher(headerValue).matches()) {
            this.processHeaderCheckingFail(headerValue);
        }
    }

    private void processHeaderCheckingFail(String headerValue) throws BadHeaderException {
        LOG.error("[WSF-Core] The request header is invalid, header name: {}.", (Object)LogUtils.cleanLog(this.header));
        throw new BadHeaderException("The request header is invalid");
    }

    public void setBlackListCheck(boolean blackListCheck) {
        this.blackListCheck = blackListCheck;
    }

    public void setHeader(String header) {
        if (header != null) {
            this.header = header;
        }
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern;
            this.valuePattern = Pattern.compile(pattern);
        }
    }

    public void setSameDomain(boolean isSameDomain) {
        if (isSameDomain) {
            this.sameDomain = true;
        }
    }
}

