/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.header.writer;

import com.huawei.springframework.security.header.readers.OverrideAddHeaderResponseWrapper;
import com.huawei.springframework.security.web.util.OmSwitch;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderWriterFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderWriterFilter.class);
    private static final String HEADER_VALUE_SPIT = "#;#";
    private static final String NO_DUPLICATE_KEY = "noDulicateResponseHeader";
    private static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    private String noDulicateResponseHeader;
    private Map<String, String[]> responseHeaderMap;
    private String omPropertyFilePath = "";
    private OmSwitch instance;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.skipFilter(servletRequest, servletResponse, chain)) {
            return;
        }
        HttpServletRequest request = RequestUtils.requestDowncast(servletRequest);
        HttpServletResponse response = RequestUtils.responseDowncast(servletResponse);
        for (Map.Entry<String, String[]> entry : this.responseHeaderMap.entrySet()) {
            for (String value : entry.getValue()) {
                if (CONTENT_SECURITY_POLICY.equalsIgnoreCase(entry.getKey())) {
                    response.addHeader(entry.getKey(), value);
                    continue;
                }
                response.setHeader(entry.getKey(), value);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)new OverrideAddHeaderResponseWrapper(response, this.noDulicateResponseHeader));
    }

    private boolean skipFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty("dynamicSwitch");
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if ("OFF".equalsIgnoreCase(closeSwitch = this.instance.getProperty("HeaderWriterFilter"))) {
                LOG.warn("[WSF-HeaderWriterFilter] OM Scenario SecureUploadFilter is skipping.");
                chain.doFilter(servletRequest, servletResponse);
                return true;
            }
        }
        return false;
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.responseHeaderMap = new HashMap<String, String[]>(8);
        this.omPropertyFilePath = config.getInitParameter("propertyFilePath");
        this.initOmFunction();
        Enumeration ex = config.getInitParameterNames();
        while (ex.hasMoreElements()) {
            boolean continueHeader;
            String headerName = (String)ex.nextElement();
            boolean bl = continueHeader = NO_DUPLICATE_KEY.equals(headerName) || "propertyFilePath".equals(headerName);
            if (continueHeader) continue;
            String headerValue = config.getInitParameter(headerName);
            String[] headerValues = headerValue.split(HEADER_VALUE_SPIT);
            this.responseHeaderMap.put(headerName, headerValues);
        }
        this.noDulicateResponseHeader = config.getInitParameter(NO_DUPLICATE_KEY);
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    public void setNoDulicateResponseHeader(String noDuplicateResponseHeader) {
        this.noDulicateResponseHeader = noDuplicateResponseHeader;
    }
}

