/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web;

import com.huawei.springframework.security.web.util.EmptyUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class SecureHttpConfiguration {
    private List<Pattern> domainWhiteList = null;
    private int maxSessionInactiveInterval;
    private boolean normalizeUrl;

    public SecureHttpConfiguration(int max_session_inactive_interval, boolean normalize_url, List<String> whiteDomainList) {
        this.normalizeUrl = normalize_url;
        if (max_session_inactive_interval <= 0) {
            throw new IllegalArgumentException("The parameter max_session_inactive_interval must larger than zero.");
        }
        this.maxSessionInactiveInterval = max_session_inactive_interval;
        if (!EmptyUtils.isEmpty(whiteDomainList)) {
            this.domainWhiteList = new LinkedList<Pattern>();
            for (String whiteDomain : whiteDomainList) {
                this.domainWhiteList.add(Pattern.compile(whiteDomain));
            }
        }
    }

    public List<Pattern> getDomainWhiteList() {
        return this.domainWhiteList;
    }

    public int getMaxSessionInactiveInterval() {
        return this.maxSessionInactiveInterval;
    }

    public boolean isNormalizeUrl() {
        return this.normalizeUrl;
    }
}

