/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web;

import com.huawei.springframework.security.web.SecureHttpConfiguration;
import com.huawei.springframework.security.web.SecureHttpRequest;
import com.huawei.springframework.security.web.SecureHttpResponse;
import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.OmSwitch;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureHttpFilter
implements Filter {
    protected static final String MAXSESSIONINACTIVEINTERVAL_FILTER_CONFIG = "max_session_inactive_interval";
    protected static final String NORMALIZEURL_FILTER_CONFIG = "normalize_url";
    protected static final String WHITEDOMAINLIST_FILTER_CONFIG = "white_domain_list";
    protected static final String SERVER_NAME = "server_name";
    private static final Logger LOG = LoggerFactory.getLogger(SecureHttpFilter.class);
    private static final String DOMAIN_SPIT = ";";
    private String omPropertyFilePath = "";
    private SecureHttpConfiguration config = null;
    private OmSwitch instance;

    public SecureHttpFilter() {
    }

    public SecureHttpFilter(SecureHttpConfiguration config) {
        this(config, null);
    }

    public SecureHttpFilter(SecureHttpConfiguration config, String serverName) {
        if (config == null) {
            throw new IllegalArgumentException("The SecureHttpConfiguration is null for constructing SecureHttpFilter.");
        }
        this.config = config;
        RequestUtils.setServerName(serverName);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.skipFilter(servletRequest, servletResponse, chain)) {
            return;
        }
        HttpServletRequest request = RequestUtils.requestDowncast(servletRequest);
        HttpServletResponse response = RequestUtils.responseDowncast(servletResponse);
        chain.doFilter((ServletRequest)new SecureHttpRequest(request, this.config), (ServletResponse)new SecureHttpResponse(response, RequestUtils.getServerName((ServletRequest)request), this.config));
    }

    private boolean skipFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty("dynamicSwitch");
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if ("OFF".equalsIgnoreCase(closeSwitch = this.instance.getProperty("SecureHttpFilter"))) {
                LOG.warn("[WSF-SecureHttpFilter] OM Scenario SecureHttpFilter is skipping.");
                chain.doFilter(servletRequest, servletResponse);
                return true;
            }
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String maxSessionConf = filterConfig.getInitParameter(MAXSESSIONINACTIVEINTERVAL_FILTER_CONFIG);
        this.omPropertyFilePath = filterConfig.getInitParameter("propertyFilePath");
        this.initOmFunction();
        int maxSessionInactiveInterval = 1800;
        if (EmptyUtils.hasText(maxSessionConf)) {
            try {
                maxSessionInactiveInterval = Integer.parseInt(maxSessionConf);
            }
            catch (NumberFormatException ex) {
                LOG.info("[WSF-Core] The parameter maxSessionInactiveInterval config error, use the default value: {}.", (Object)maxSessionInactiveInterval);
            }
        }
        boolean normalizeUrl = true;
        String normalizeUrlConf = filterConfig.getInitParameter(NORMALIZEURL_FILTER_CONFIG);
        if ("false".equalsIgnoreCase(normalizeUrlConf)) {
            normalizeUrl = false;
        }
        ArrayList<String> whiteDomainList = new ArrayList<String>();
        String whiteDomainListConf = filterConfig.getInitParameter(WHITEDOMAINLIST_FILTER_CONFIG);
        if (EmptyUtils.hasText(whiteDomainListConf)) {
            String[] whitelist;
            for (String value : whitelist = whiteDomainListConf.split(DOMAIN_SPIT)) {
                if (!EmptyUtils.hasText(value)) continue;
                whiteDomainList.add(value);
            }
        }
        RequestUtils.setServerName(filterConfig.getInitParameter(SERVER_NAME));
        this.config = new SecureHttpConfiguration(maxSessionInactiveInterval, normalizeUrl, whiteDomainList);
    }

    public void setServerName(String serverName) {
        RequestUtils.setServerName(serverName);
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    public void destroy() {
    }
}

