/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web;

import com.huawei.springframework.security.web.SecureHttpConfiguration;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public final class SecureHttpRequest
extends HttpServletRequestWrapper {
    private SecureHttpConfiguration configuration = null;
    private String normalizeUri = null;
    private String primalUrl = null;
    private String primalUri = null;
    private String normalizeUrl = null;

    public SecureHttpRequest(HttpServletRequest request, SecureHttpConfiguration configuration) {
        super(request);
        this.configuration = configuration;
    }

    public String getRequestURI() {
        if (this.configuration.isNormalizeUrl()) {
            if (this.normalizeUri == null || this.isRefreshURI()) {
                this.normalizeUri = RequestUtils.getNormalizeRequestURI(this.getRequest());
            }
            return this.normalizeUri;
        }
        return super.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        if (this.configuration.isNormalizeUrl()) {
            if (this.normalizeUrl == null || this.isRefreshURL()) {
                this.normalizeUrl = RequestUtils.getNormalizeRequestURL(this.getRequest());
            }
            return new StringBuffer(this.normalizeUrl);
        }
        return super.getRequestURL();
    }

    public HttpSession getSession() {
        return this.resetSessionInactiveInterval(super.getSession());
    }

    public HttpSession getSession(boolean create) {
        return this.resetSessionInactiveInterval(super.getSession(create));
    }

    private HttpSession resetSessionInactiveInterval(HttpSession session) {
        if (session != null && session.getMaxInactiveInterval() > this.configuration.getMaxSessionInactiveInterval()) {
            session.setMaxInactiveInterval(this.configuration.getMaxSessionInactiveInterval());
        }
        return session;
    }

    private boolean isRefreshURI() {
        String currentURI = this.getURIFromRequest();
        if (currentURI == null) {
            if (this.primalUri == null) {
                return false;
            }
            this.primalUri = null;
            return true;
        }
        if (!currentURI.equals(this.primalUri)) {
            this.primalUri = currentURI;
            return true;
        }
        return false;
    }

    private boolean isRefreshURL() {
        String currentURL = this.getURLFromRequest().orElse(null);
        if (currentURL == null) {
            if (this.primalUrl == null) {
                return false;
            }
            this.primalUrl = null;
            return true;
        }
        if (!currentURL.equals(this.primalUrl)) {
            this.primalUrl = currentURL;
            return true;
        }
        return false;
    }

    private String getURIFromRequest() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return request.getRequestURI();
    }

    private Optional<String> getURLFromRequest() {
        if (!(this.getRequest() instanceof HttpServletRequest)) {
            return Optional.empty();
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        if (request.getRequestURL() == null) {
            return Optional.empty();
        }
        return Optional.of(request.getRequestURL().toString());
    }
}

