/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web;

import com.huawei.springframework.security.web.SecureHttpConfiguration;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class SecureHttpResponse
extends HttpServletResponseWrapper {
    private List<Pattern> domainWhiteList = null;
    private String serverName = null;

    public SecureHttpResponse(HttpServletResponse response, String serverName, SecureHttpConfiguration config) {
        super(response);
        this.serverName = serverName;
        this.domainWhiteList = config.getDomainWhiteList();
    }

    public void sendRedirect(String location) throws IOException {
        if (location == null) {
            throw new IOException("The redirect location is null.");
        }
        URI url = URI.create(location);
        String domain = url.getHost();
        if (domain == null) {
            if (location.contains("//")) {
                throw new IOException("The redirect location isn't in the security white list.");
            }
            String tmpLocation = location.trim();
            if (!tmpLocation.startsWith("/")) {
                tmpLocation = "/" + tmpLocation;
            }
            super.sendRedirect(tmpLocation);
            return;
        }
        if (domain.equals(this.serverName)) {
            super.sendRedirect(location);
            return;
        }
        if (this.domainWhiteList != null) {
            for (Pattern pattern : this.domainWhiteList) {
                if (!pattern.matcher(domain).matches()) continue;
                super.sendRedirect(location);
                return;
            }
        }
        throw new IOException("The redirect location isn't in the security white list.");
    }
}

