/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.access;

import com.huawei.springframework.security.web.access.DefaultAccessDeniedHandlerImpl;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.security.web.csrf.MissingCsrfTokenException;

public class CsrfAccessDeniedHandlerImpl
extends DefaultAccessDeniedHandlerImpl {
    public static final String SESSION_CSRF_ERROR_KEY = "SESSION.CSRF.ERROR.KEY";
    private ReentrantLock lock = new ReentrantLock();
    private int maxErrors = 5;
    private boolean sessionInvalidate = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        HttpSession session;
        if ((accessDeniedException instanceof MissingCsrfTokenException || accessDeniedException instanceof InvalidCsrfTokenException) && (session = request.getSession()) != null) {
            this.lock.lock();
            try {
                this.handleSession(session);
            }
            finally {
                this.lock.unlock();
            }
        }
        super.handle(request, response, accessDeniedException);
    }

    private void handleSession(HttpSession session) {
        Object errorsInteger = session.getAttribute(SESSION_CSRF_ERROR_KEY);
        int errors = 1;
        if (errorsInteger instanceof Integer) {
            errors = (Integer)errorsInteger + 1;
        }
        if (errors >= this.maxErrors && this.sessionInvalidate) {
            session.invalidate();
        } else {
            session.setAttribute(SESSION_CSRF_ERROR_KEY, (Object)errors);
        }
    }

    public void setMaxErrors(int errors) {
        if (errors <= 0) {
            throw new IllegalArgumentException("The allowed error numbers must be positive.");
        }
        this.maxErrors = errors;
    }

    public void setSessionInvalidate(boolean sessionInvalidate) {
        this.sessionInvalidate = sessionInvalidate;
    }
}

