/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.access;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class DefaultAccessDeniedHandlerImpl
implements AccessDeniedHandler {
    private static final String ERROR_MSG = "InValid CSRF Token";
    private String errorPage;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (response.isCommitted()) {
            return;
        }
        if (this.errorPage != null) {
            request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
            response.setStatus(HttpStatus.FORBIDDEN.value());
            RequestDispatcher dispatcher = request.getRequestDispatcher(this.errorPage);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            response.setStatus(403);
            if (response.getWriter() != null) {
                response.getWriter().write(ERROR_MSG);
            }
        }
    }

    public void setErrorPage(String errorPage) {
        if (errorPage != null && !errorPage.startsWith("/")) {
            throw new IllegalArgumentException("The errorPage must begin with '/'");
        }
        this.errorPage = errorPage;
    }
}

