/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.cookie;

import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.OmSwitch;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieFilter
implements Filter {
    protected static final String COOKIE_SPIT = ";";
    protected static final String HTTPONLY_WHITELIST_FILTER_CONFIG = "httponly_white_list";
    protected static final String SECURE_FILTER_CONFIG = "secure";
    private static final Logger LOG = LoggerFactory.getLogger(CookieFilter.class);
    private Map<String, String> httponlyWhiteList = null;
    private boolean lowServletVersion = true;
    private OmSwitch instance;
    private boolean secure = true;
    private String omPropertyFilePath = "";

    public CookieFilter() {
        Method[] methods;
        Class<Cookie> clazz = Cookie.class;
        for (Method method : methods = clazz.getMethods()) {
            if (!"setHttpOnly".equals(method.getName())) continue;
            this.lowServletVersion = false;
            break;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.skipFilter(servletRequest, servletResponse, chain)) {
            return;
        }
        HttpServletRequest request = RequestUtils.requestDowncast(servletRequest);
        HttpServletResponse response = RequestUtils.responseDowncast(servletResponse);
        CookieHttpServletResponse cookieResponse = new CookieHttpServletResponse(response, this.httponlyWhiteList, this.secure);
        chain.doFilter((ServletRequest)request, (ServletResponse)cookieResponse);
    }

    private boolean skipFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty("dynamicSwitch");
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if ("OFF".equalsIgnoreCase(closeSwitch = this.instance.getProperty("CookieFilter"))) {
                LOG.warn("[WSF-CookieFilter] OM Scenario CookieFilter is skipping.");
                chain.doFilter(servletRequest, servletResponse);
                return true;
            }
        }
        return false;
    }

    public Map<String, String> getHttponlyWhiteList() {
        return this.httponlyWhiteList;
    }

    public void setHttponlyWhiteList(Map<String, String> httponlyWhiteList) {
        this.httponlyWhiteList = httponlyWhiteList;
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        String secureConfig = config.getInitParameter(SECURE_FILTER_CONFIG);
        this.omPropertyFilePath = config.getInitParameter("propertyFilePath");
        this.initOmFunction();
        if ("false".equalsIgnoreCase(secureConfig)) {
            this.secure = false;
        }
        this.httponlyWhiteList = new HashMap<String, String>(8);
        String whitelistConfig = config.getInitParameter(HTTPONLY_WHITELIST_FILTER_CONFIG);
        if (EmptyUtils.hasText(whitelistConfig)) {
            String[] whitelist;
            for (String value : whitelist = whitelistConfig.split(COOKIE_SPIT)) {
                if (!EmptyUtils.hasText(value)) continue;
                this.httponlyWhiteList.put(value, "");
            }
        }
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    private class CookieHttpServletResponse
    extends HttpServletResponseWrapper {
        private static final String SET_COOKIE = "Set-Cookie";
        private Map<String, String> httpOnlyWhiteList;
        private boolean secure;

        CookieHttpServletResponse(HttpServletResponse response, Map<String, String> whiteList, boolean secure) {
            super(response);
            this.httpOnlyWhiteList = null;
            this.secure = true;
            this.httpOnlyWhiteList = whiteList;
            this.secure = secure;
        }

        public void addCookie(Cookie cookie) {
            String cookieName = cookie.getName();
            boolean httpOnly = this.isSetHttpOnly(cookieName);
            if (!httpOnly && !this.secure) {
                super.addCookie(cookie);
                return;
            }
            if (!CookieFilter.this.lowServletVersion) {
                if (httpOnly) {
                    cookie.setHttpOnly(true);
                }
                if (this.secure) {
                    cookie.setSecure(true);
                }
                super.addCookie(cookie);
            } else {
                super.addHeader(SET_COOKIE, this.cookie2String(cookie));
            }
        }

        public void addHeader(String name, String value) {
            if (!SET_COOKIE.equalsIgnoreCase(name)) {
                super.addHeader(name, value);
                return;
            }
            String cookieName = this.parseCookieName(value);
            boolean httpOnly = this.isSetHttpOnly(cookieName);
            if (!httpOnly && !this.secure) {
                super.addHeader(name, value);
                return;
            }
            StringBuilder strBufferCookie = new StringBuilder(value.trim());
            String lowValue = strBufferCookie.toString().toLowerCase(Locale.ENGLISH);
            if (httpOnly && !this.containsByReg(lowValue, ";\\s*httponly")) {
                strBufferCookie.append("; HTTPOnly");
            }
            if (this.secure && !this.containsByReg(lowValue, ";\\s*Secure")) {
                strBufferCookie.append("; Secure");
            }
            super.addHeader(SET_COOKIE, strBufferCookie.toString().replace(";;", CookieFilter.COOKIE_SPIT));
        }

        private boolean containsByReg(String content, String reg) {
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(content);
            return matcher.find();
        }

        private String cookie2String(Cookie cookie) {
            String cookieName = cookie.getName();
            String path = cookie.getPath();
            String domain = cookie.getDomain();
            StringBuilder strBufferCookie = new StringBuilder();
            strBufferCookie.append(cookieName).append('=').append(cookie.getValue()).append(';');
            if (cookie.getMaxAge() >= 0) {
                strBufferCookie.append("Max-Age=").append(cookie.getMaxAge()).append(';');
            }
            if (domain != null) {
                strBufferCookie.append("domain=").append(domain).append(';');
            }
            if (path != null) {
                strBufferCookie.append("path=").append(path).append(';');
            }
            if (this.secure || cookie.getSecure()) {
                strBufferCookie.append("secure;");
            }
            if (this.isSetHttpOnly(cookieName)) {
                strBufferCookie.append("HTTPOnly;");
            }
            return strBufferCookie.toString();
        }

        private boolean isSetHttpOnly(String cookieName) {
            return this.httpOnlyWhiteList == null || !this.httpOnlyWhiteList.containsKey(cookieName);
        }

        private String parseCookieName(String value) {
            String[] items = value.split(CookieFilter.COOKIE_SPIT);
            if (items.length == 0) {
                return value;
            }
            return items[0].split("=")[0];
        }
    }
}

