/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import com.huawei.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;

public final class AntiCsrfUtils {
    public static final String CSRF_DOMAIN = "csrf_domain";
    public static final String CSRF_HEADER = "csrf_header";
    public static final String CSRF_PARAM = "csrf_param";
    public static final String CSRF_TOKEN = "csrf_token";
    private static final Logger LOG = LoggerFactory.getLogger(AntiCsrfUtils.class);
    private static final String SPILT = "%#%";
    private static final String URL_METHOD_SPLIT = ":";
    private static final char DOMAIN_QUOTATION_MARKS = '\"';
    private static final String VALUE_SPIT = "#;#";
    private static CsrfTokenRepository tokenRepository;
    private static String domains;

    private AntiCsrfUtils() {
    }

    public static String generateAntiCsrfScript(HttpServletRequest request, String scriptTemplate) {
        String[] scriptSegments = new String[]{""};
        if (EmptyUtils.hasText(scriptTemplate)) {
            scriptSegments = scriptTemplate.split(SPILT);
        }
        StringBuilder result = new StringBuilder(scriptTemplate.length());
        if (tokenRepository != null && !HttpSessionCsrfTokenRepository.class.getName().equals(tokenRepository.getClass().getName())) {
            CsrfToken token = tokenRepository.loadToken(request);
            HashMap<String, String> tokenMap = new HashMap<String, String>(4);
            AntiCsrfUtils.setTokenMap(token, tokenMap);
            StringBuilder localDomain = new StringBuilder();
            if (EmptyUtils.hasText(domains)) {
                localDomain.append(domains);
            }
            localDomain.append('\"').append(RequestUtils.getLocalDomain(request)).append('\"');
            tokenMap.put(CSRF_DOMAIN, localDomain.toString());
            AntiCsrfUtils.appendResult(scriptSegments, result, tokenMap);
        } else {
            HttpSession session = request.getSession(false);
            if (session == null) {
                return "";
            }
            for (int index = 0; index < scriptSegments.length; ++index) {
                if (index % 2 == 0) {
                    result.append(scriptSegments[index]);
                    continue;
                }
                result.append(session.getAttribute(scriptSegments[index]));
            }
        }
        return result.toString();
    }

    private static void setTokenMap(CsrfToken token, Map<String, String> tokenMap) {
        if (token != null) {
            tokenMap.put(CSRF_HEADER, token.getHeaderName());
            tokenMap.put(CSRF_PARAM, token.getParameterName());
            tokenMap.put(CSRF_TOKEN, token.getToken());
        } else {
            tokenMap.put(CSRF_HEADER, "");
            tokenMap.put(CSRF_PARAM, "");
            tokenMap.put(CSRF_TOKEN, "");
        }
    }

    private static void appendResult(String[] scriptSegments, StringBuilder result, Map<String, String> tokenMap) {
        for (int index = 0; index < scriptSegments.length; ++index) {
            if (index % 2 == 0) {
                result.append(scriptSegments[index]);
                continue;
            }
            result.append(tokenMap.get(scriptSegments[index]));
        }
    }

    public static Map<String, String> parseWhiteList(String[] urls) {
        LinkedHashMap<String, String> csrfWhiteListMap = new LinkedHashMap<String, String>();
        for (String url : urls) {
            String[] urlMethod = url.split(URL_METHOD_SPLIT);
            if (urlMethod.length >= 2) {
                if (EmptyUtils.hasText(urlMethod[1])) {
                    csrfWhiteListMap.put(urlMethod[0].trim(), urlMethod[1].trim());
                    continue;
                }
                csrfWhiteListMap.put(urlMethod[0].trim(), "GET|HEAD|TRACE|OPTIONS");
                continue;
            }
            if (urlMethod.length == 1 && EmptyUtils.hasText(urlMethod[0])) {
                csrfWhiteListMap.put(urlMethod[0].trim(), "GET|HEAD|TRACE|OPTIONS");
                continue;
            }
            LOG.debug("[WSF-Core] Url is empty.");
        }
        return csrfWhiteListMap;
    }

    public static CsrfTokenRepository getTokenRepository() {
        return tokenRepository;
    }

    public static void setTokenRepository(CsrfTokenRepository tokenRepository) {
        AntiCsrfUtils.tokenRepository = tokenRepository;
    }

    public static String getDomains() {
        return domains;
    }

    public static void setDomains(String domainsConfig) {
        if (EmptyUtils.hasText(domainsConfig)) {
            Pattern pattern = Pattern.compile(VALUE_SPIT);
            Matcher matcher = pattern.matcher(domainsConfig);
            StringBuffer encodedDomains = new StringBuffer();
            encodedDomains.append('\"');
            while (matcher.find()) {
                matcher.appendReplacement(encodedDomains, "\",\"");
            }
            matcher.appendTail(encodedDomains);
            encodedDomains.append('\"').append(',');
            domains = encodedDomains.toString();
        }
    }
}

