/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(Cache.class);
    private final MemoryCounter counter = new MemoryCounter();
    private long generalCacheSize = 0L;
    private Map<K, V> internalMap = null;
    private int maxMemorySize = 0;
    private long maxPerObjectSize = 0L;

    public Cache(int initialSize, int maxMemorySize, int maxPerObjectSize) {
        if (maxMemorySize <= 0 || initialSize <= 0) {
            throw new IllegalArgumentException("The max memory size or initial size must be positive number.");
        }
        this.maxMemorySize = maxMemorySize * 1024 * 1024;
        this.internalMap = new HashMap(initialSize);
        this.maxPerObjectSize = maxPerObjectSize;
    }

    public V get(K key) {
        return this.internalMap.get(key);
    }

    public V put(K key, V value) throws OutOfLimitException {
        long memorySize = this.sizeOf(key) + this.sizeOf(value);
        if (this.generalCacheSize + memorySize > (long)this.maxMemorySize) {
            this.reorganize();
        }
        this.generalCacheSize += memorySize;
        return this.internalMap.put(key, value);
    }

    public V remove(K key) throws OutOfLimitException {
        V value = this.internalMap.remove(key);
        if (value != null) {
            this.generalCacheSize -= this.sizeOf(key) + this.sizeOf(value);
        }
        return value;
    }

    protected void reorganize() throws OutOfLimitException {
        throw new OutOfLimitException("Cache is full, can't insert or change the value.");
    }

    public int size() {
        return this.internalMap.size();
    }

    protected <T> long sizeOf(T obj) throws OutOfLimitException {
        long size = this.counter.estimate(obj);
        if (size > this.maxPerObjectSize) {
            throw new OutOfLimitException("The object size is" + size + ", which is bigger than the defined size.");
        }
        return size;
    }

    static class MemoryCounter {
        private final MemorySizes sizes = new MemorySizes();
        private final Deque<Object> stk = new ArrayDeque<Object>();
        private final Map<Object, Object> visitedMap = new IdentityHashMap<Object, Object>();

        MemoryCounter() {
        }

        public synchronized <T> long estimate(T object) {
            long rst = this.estimateObject(object);
            while (!this.stk.isEmpty()) {
                rst += this.estimateObject(this.stk.pop());
            }
            this.visitedMap.clear();
            return rst;
        }

        protected <T> long estimateArray(T object) {
            long rst = 16L;
            int len = Array.getLength(object);
            if (len == 0) {
                return rst;
            }
            Class<?> arrayElementClazz = object.getClass().getComponentType();
            if (arrayElementClazz != null && arrayElementClazz.isPrimitive()) {
                rst += (long)(len * this.sizes.getPrimitiveArrayElementSize(arrayElementClazz));
            } else {
                for (int i = 0; i < len; ++i) {
                    rst += 4L + this.estimateObject(Array.get(object, i));
                }
            }
            return rst;
        }

        private <T> long estimateObject(T object) {
            Class<?> cla;
            if (this.skipObject(object)) {
                return 0L;
            }
            this.visitedMap.put(object, null);
            if (cla.isArray()) {
                return this.estimateArray(object);
            }
            long rst = 0L;
            for (cla = object.getClass(); cla != null; cla = cla.getSuperclass()) {
                rst += this.genFileHandler(object, cla);
            }
            return this.roundUpToNearestEightBytes(rst += 8L);
        }

        private <T> long genFileHandler(T object, Class<?> cla) {
            Field[] declaredFields;
            long rst = 0L;
            for (Field declaredField : declaredFields = cla.getDeclaredFields()) {
                if (Modifier.isStatic(declaredField.getModifiers())) continue;
                if (declaredField.getType().isPrimitive()) {
                    rst += (long)this.sizes.getPrimitiveFieldSize(declaredField.getType());
                    continue;
                }
                rst += 4L;
                declaredField.setAccessible(true);
                Object doneObject = null;
                try {
                    doneObject = declaredField.get(object);
                }
                catch (IllegalAccessException e) {
                    LOG.error("[WSF-Cache] Estimate object size failed. {}", (Object)e.getMessage());
                }
                if (doneObject == null) continue;
                this.stk.add(doneObject);
            }
            return rst;
        }

        private long roundUpToNearestEightBytes(long data) {
            long result = data;
            int javaObjectEightBytesMem = 8;
            if (data % (long)javaObjectEightBytesMem != 0L) {
                result += (long)javaObjectEightBytesMem - result % (long)javaObjectEightBytesMem;
            }
            return result;
        }

        private <T> boolean skipObject(T object) {
            return object == null || this.visitedMap.containsKey(object);
        }
    }

    public static class OutOfLimitException
    extends Exception {
        private static final long serialVersionUID = 1386671189683072706L;

        OutOfLimitException(String message) {
            super(message);
        }
    }

    static class MemorySizes {
        protected static final int CLASS_SIZE = 8;
        protected static final int POINTER_SIZE = 4;
        private static final Map<Class<?>, Integer> PRIMITIVE_SIZES = new InnerSize();

        MemorySizes() {
        }

        public int getPrimitiveArrayElementSize(Class<?> cla) {
            return this.getPrimitiveFieldSize(cla);
        }

        public int getPrimitiveFieldSize(Class<?> cla) {
            return PRIMITIVE_SIZES.get(cla);
        }

        static class InnerSize
        extends IdentityHashMap<Class<?>, Integer> {
            private static final long serialVersionUID = 4138813072425637503L;

            InnerSize() {
                super.put(Boolean.TYPE, 1);
                super.put(Byte.TYPE, 1);
                super.put(Character.TYPE, 2);
                super.put(Short.TYPE, 2);
                super.put(Integer.TYPE, 4);
                super.put(Float.TYPE, 4);
                super.put(Double.TYPE, 8);
                super.put(Long.TYPE, 8);
            }
        }
    }
}

