/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import com.huawei.springframework.security.web.access.DefaultAccessDeniedHandlerImpl;
import com.huawei.springframework.security.web.csrf.AntiCsrfUtils;
import com.huawei.springframework.security.web.csrf.CsrfPathRequestMatcher;
import com.huawei.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import com.huawei.springframework.security.web.csrf.TokenSecureRandom;
import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.OmSwitch;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfAntiFilter
implements Filter {
    private static final String ACCESS_DENIED_HANDLER = "access_denied_handler";
    private static final Logger LOG = LoggerFactory.getLogger(CsrfAntiFilter.class);
    private static final String CSRF_TOKEN_REPOSITORY_CONFIG = "csrf_token_repository";
    private static final String ONCE_CSRF_TOKEN_COOKE = "OnceCsrfToken";
    private static final String ONCE_CSRF_TOKEN_REPOSITORY_CONFIG = "once_csrf_token_repository";
    private static final String ONCE_TOKEN_FILTER_CONFIG = "once_token_enable";
    private static final String WHITELIST_FILTER_CONFIG = "csrf_white_list";
    private static final String URL_NORMALIZE_CONFIG = "url_normalize_enable";
    private static final String WHITELIST_SPLIT = ";";
    private AccessDeniedHandler accessDeniedHandler = new DefaultAccessDeniedHandlerImpl();
    private boolean oncetokenEnable = false;
    private boolean urlNormalizeEnable = false;
    private CsrfTokenRepository onceTokenRepository;
    private RequestMatcher requireCsrfProtectionMatcher = new DefaultRequiresCsrfRequestMatcher();
    private CsrfTokenRepository tokenRepository;
    private String omPropertyFilePath = "";
    private OmSwitch instance;

    public CsrfAntiFilter() {
        this(new HttpSessionCsrfTokenRepository());
    }

    public CsrfAntiFilter(CsrfTokenRepository csrfTokenRepository) {
        this(csrfTokenRepository, null);
    }

    public CsrfAntiFilter(CsrfTokenRepository csrfTokenRepository, CsrfTokenRepository onceCsrfTokenRep) {
        this.tokenRepository = csrfTokenRepository != null ? csrfTokenRepository : new HttpSessionCsrfTokenRepository();
        AntiCsrfUtils.setTokenRepository(this.tokenRepository);
        if (onceCsrfTokenRep != null) {
            this.onceTokenRepository = onceCsrfTokenRep;
        } else {
            HttpSessionCsrfTokenRepository httpTokenRepository = new HttpSessionCsrfTokenRepository();
            String attributeName = HttpSessionCsrfTokenRepository.class.getName().concat(".ONCE_CSRF_TOKEN");
            httpTokenRepository.setSessionAttributeName(attributeName);
            httpTokenRepository.setSaveOnceToken(true);
            this.onceTokenRepository = httpTokenRepository;
        }
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.skipFilter(servletRequest, servletResponse, chain)) {
            return;
        }
        HttpServletRequest request = RequestUtils.requestDowncast(servletRequest);
        HttpServletResponse response = RequestUtils.responseDowncast(servletResponse);
        CsrfToken sessionCsrfToken = this.tokenRepository.loadToken(request);
        CsrfToken onceCsrfToken = this.onceTokenRepository.loadToken(request);
        boolean missToken = false;
        if (sessionCsrfToken == null) {
            missToken = true;
            sessionCsrfToken = this.tokenRepository.generateToken(request);
            this.tokenRepository.saveToken(sessionCsrfToken, request, response);
        }
        if (onceCsrfToken == null) {
            missToken = true;
            onceCsrfToken = this.generateOnceToken(request, response);
        }
        request.setAttribute(CsrfToken.class.getName(), (Object)sessionCsrfToken);
        request.setAttribute(sessionCsrfToken.getParameterName(), (Object)sessionCsrfToken);
        if (!this.requireCsrfProtectionMatcher.matches(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requestToken = request.getHeader(sessionCsrfToken.getHeaderName());
        if (requestToken == null) {
            requestToken = request.getParameter(sessionCsrfToken.getParameterName());
        }
        if (sessionCsrfToken.getToken().equals(requestToken)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.oncetokenEnable && onceCsrfToken.getToken().equalsIgnoreCase(requestToken)) {
            this.generateOnceToken(request, response);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.dealHandler(request, response, sessionCsrfToken, missToken, requestToken);
        }
    }

    private boolean skipFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty("dynamicSwitch");
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if ("OFF".equalsIgnoreCase(closeSwitch = this.instance.getProperty("CsrfFilter"))) {
                LOG.warn("[WSF-CsrfFilter] OM Scenario CsrfAntiFilter is skipping.");
                chain.doFilter(servletRequest, servletResponse);
                return true;
            }
        }
        return false;
    }

    private void dealHandler(HttpServletRequest request, HttpServletResponse response, CsrfToken sessionCsrfToken, boolean missToken, String requestToken) throws IOException, ServletException {
        if (missToken) {
            this.accessDeniedHandler.handle(request, response, (AccessDeniedException)new MissingCsrfTokenException(requestToken));
        } else {
            this.accessDeniedHandler.handle(request, response, (AccessDeniedException)new InvalidCsrfTokenException(sessionCsrfToken, requestToken));
        }
    }

    private CsrfToken generateOnceToken(HttpServletRequest request, HttpServletResponse response) {
        CsrfToken token = this.onceTokenRepository.generateToken(request);
        this.onceTokenRepository.saveToken(token, request, response);
        if (this.oncetokenEnable) {
            Cookie cookie = new Cookie(ONCE_CSRF_TOKEN_COOKE, token.getToken());
            cookie.setPath(request.getServletContext().getContextPath() + "/");
            response.addCookie(cookie);
        }
        return token;
    }

    public void destroy() {
    }

    public void init(FilterConfig conf) throws ServletException {
        String handler;
        String octr;
        String ctr;
        this.omPropertyFilePath = conf.getInitParameter("propertyFilePath");
        this.initOmFunction();
        String randomGenerator = conf.getInitParameter("randomGenerator");
        TokenSecureRandom.initInstance(randomGenerator);
        String enable = conf.getInitParameter(ONCE_TOKEN_FILTER_CONFIG);
        String urlNormalizeConfig = conf.getInitParameter(URL_NORMALIZE_CONFIG);
        this.oncetokenEnable = EmptyUtils.isTure(enable);
        this.urlNormalizeEnable = EmptyUtils.isTure(urlNormalizeConfig);
        String whiteListString = conf.getInitParameter(WHITELIST_FILTER_CONFIG);
        if (whiteListString != null) {
            String[] urlPatterns = whiteListString.split(WHITELIST_SPLIT);
            Map<String, String> whiteList = AntiCsrfUtils.parseWhiteList(urlPatterns);
            this.requireCsrfProtectionMatcher = new CsrfPathRequestMatcher(whiteList, this.urlNormalizeEnable);
        }
        if (EmptyUtils.hasText(ctr = conf.getInitParameter(CSRF_TOKEN_REPOSITORY_CONFIG))) {
            this.tokenRepository = this.createCsrfTokenRepository(ctr);
            LOG.info("[WSF-Core] The token repository is defined by user.");
            AntiCsrfUtils.setTokenRepository(this.tokenRepository);
        }
        if (EmptyUtils.hasText(octr = conf.getInitParameter(ONCE_CSRF_TOKEN_REPOSITORY_CONFIG))) {
            this.onceTokenRepository = this.createCsrfTokenRepository(octr);
        }
        if (EmptyUtils.hasText(handler = conf.getInitParameter(ACCESS_DENIED_HANDLER))) {
            this.accessDeniedHandler = this.createAccessDeniedHandler(handler);
        }
    }

    private AccessDeniedHandler createAccessDeniedHandler(String handler) throws ServletException {
        try {
            Object handlerInstance = Class.forName(handler).newInstance();
            if (handlerInstance instanceof AccessDeniedHandler) {
                return (AccessDeniedHandler)handlerInstance;
            }
            throw new ServletException("Reflect access denied handler failed.");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ServletException("Reflect access denied handler failed! " + ex.getMessage(), (Throwable)ex);
        }
    }

    private CsrfTokenRepository createCsrfTokenRepository(String csrfTokenRepository) throws ServletException {
        try {
            Object ctrInstance = Class.forName(csrfTokenRepository).newInstance();
            if (ctrInstance instanceof CsrfTokenRepository) {
                return (CsrfTokenRepository)ctrInstance;
            }
            throw new ServletException("Reflect token repository failed.");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ServletException("Reflect token repository failed! " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setAccessDeniedHandler(AccessDeniedHandler handler) {
        if (handler != null) {
            this.accessDeniedHandler = handler;
        }
    }

    public void setOncetokenEnable(boolean oncetokenEnable) {
        this.oncetokenEnable = oncetokenEnable;
    }

    public void setRequireCsrfProtectionMatcher(RequestMatcher csrfProtectionMatcher) {
        if (csrfProtectionMatcher != null) {
            this.requireCsrfProtectionMatcher = csrfProtectionMatcher;
        }
    }

    private static final class DefaultRequiresCsrfRequestMatcher
    implements RequestMatcher {
        private Pattern notRequiresProtectionMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");

        private DefaultRequiresCsrfRequestMatcher() {
        }

        public boolean matches(HttpServletRequest req) {
            return !this.notRequiresProtectionMethods.matcher(req.getMethod()).matches();
        }
    }
}

