/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import com.huawei.springframework.security.web.csrf.AntiCsrfUtils;
import com.huawei.springframework.security.web.csrf.CsrfPathRequestMatcher;
import com.huawei.springframework.security.web.csrf.ScripInjectResponseWrapper;
import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.FileLoadUtil;
import com.huawei.springframework.security.web.util.OmSwitch;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfInjectTokenFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CsrfInjectTokenFilter.class);
    private static final String CONTENT_TYPE_WHITE_LIST_CONFIG = "content-type-white-list";
    private static final String TEMP_FILE_NAME = "anticsrf_hwsf.temp";
    private static final String URL_PATTERN_WHITE_LIST_CONFIG = "url-pattern-white-list";
    private static final String URL_NORMALIZE_CONFIG = "url_normalize_enable";
    private static final String DOMAIN_LIST_CONFIG = "domain_list";
    private static final String VALUE_SPIT = "#;#";
    private static final String CSRF_TOKEN_COOKE = "csrfToken";
    private static final String COOKIE_TOKEN_FILTER_CONFIG = "cookie_token_switch";
    private static final String COOKIE_TOKEN_MAX_AGE_FILTER_CONFIG = "cookie_token_max_age";
    private volatile String scriptTemplate = "";
    private boolean urlNormalizeEnable = false;
    private boolean cookieTokenSwitch = false;
    private Integer cookieMaxAge = -1;
    private Map<String, String> contentTypeList = null;
    private String domains;
    private RequestMatcher requireCsrfInjectTokenMatcher = null;
    private String omPropertyFilePath = "";
    private OmSwitch instance;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.skipFilter(servletRequest, servletResponse, filterChain)) {
            return;
        }
        HttpServletRequest request = RequestUtils.requestDowncast(servletRequest);
        HttpServletResponse response = RequestUtils.responseDowncast(servletResponse);
        if (this.requireCsrfInjectTokenMatcher != null && !this.requireCsrfInjectTokenMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.cookieTokenSwitch) {
            if (!this.contentTypeMatch(request.getContentType())) {
                this.addTokenToCookie(request, response);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            ScripInjectResponseWrapper responseWrapper = new ScripInjectResponseWrapper(response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            long scriptLen = 0L;
            if (!this.contentTypeMatch(responseWrapper.getContentType())) {
                scriptLen = this.writeScriptToResponse(request, response, responseWrapper);
            }
            if (responseWrapper.isSetContentLength()) {
                response.setHeader("Content-Length", Long.toString(responseWrapper.getContentLength() + scriptLen));
            }
        }
    }

    private void addTokenToCookie(HttpServletRequest request, HttpServletResponse response) {
        String tokenVal;
        CsrfToken token = AntiCsrfUtils.getTokenRepository().loadToken(request);
        if (token == null) {
            LOG.error("[WSF-Core] Can't load token,session may be illegal.");
            tokenVal = "";
        } else {
            tokenVal = token.getToken();
        }
        if (this.requireCsrfInjectTokenMatcher.matches(request)) {
            Cookie cookie = new Cookie(CSRF_TOKEN_COOKE, tokenVal);
            cookie.setSecure(request.isSecure());
            cookie.setHttpOnly(false);
            cookie.setPath(request.getServletContext().getContextPath() + "/");
            cookie.setMaxAge(this.cookieMaxAge.intValue());
            response.addCookie(cookie);
        }
    }

    private boolean skipFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty("dynamicSwitch");
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if ("OFF".equalsIgnoreCase(closeSwitch = this.instance.getProperty("CsrfFilter"))) {
                LOG.warn("[WSF-CsrfInjectTokenFilter] OM Scenario CsrfInjectTokenFilter is skipping.");
                filterChain.doFilter(servletRequest, servletResponse);
                return true;
            }
        }
        return false;
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    public void init(FilterConfig conf) throws ServletException {
        String ctma;
        String cookieSwitch;
        this.omPropertyFilePath = conf.getInitParameter("propertyFilePath");
        this.initOmFunction();
        String contentType = conf.getInitParameter(CONTENT_TYPE_WHITE_LIST_CONFIG);
        if (EmptyUtils.hasText(contentType)) {
            String[] cts = contentType.split(VALUE_SPIT);
            this.contentTypeList = new HashMap<String, String>(cts.length);
            for (String ct : cts) {
                if (!EmptyUtils.hasText(ct)) continue;
                this.contentTypeList.put(ct, "");
            }
        }
        if ((cookieSwitch = conf.getInitParameter(COOKIE_TOKEN_FILTER_CONFIG)) != null && "true".equals(cookieSwitch.trim().toLowerCase(Locale.ENGLISH))) {
            this.cookieTokenSwitch = true;
        }
        if ((ctma = conf.getInitParameter(COOKIE_TOKEN_MAX_AGE_FILTER_CONFIG)) != null) {
            try {
                this.cookieMaxAge = Integer.parseInt(ctma);
            }
            catch (NumberFormatException e) {
                LOG.warn("[WSF-Core] The cookie MaxAge may be illegal.");
                this.cookieMaxAge = -1;
            }
        }
        String urlNormalizeConfig = conf.getInitParameter(URL_NORMALIZE_CONFIG);
        this.urlNormalizeEnable = EmptyUtils.isTure(urlNormalizeConfig);
        String domainString = conf.getInitParameter(DOMAIN_LIST_CONFIG);
        AntiCsrfUtils.setDomains(domainString);
        String urlPatterns = conf.getInitParameter(URL_PATTERN_WHITE_LIST_CONFIG);
        if (EmptyUtils.isEmpty(urlPatterns)) {
            return;
        }
        String[] urls = urlPatterns.split(VALUE_SPIT);
        Map<String, String> urlWhiteListMap = AntiCsrfUtils.parseWhiteList(urls);
        this.requireCsrfInjectTokenMatcher = new CsrfPathRequestMatcher(urlWhiteListMap, this.urlNormalizeEnable);
    }

    public Map<String, String> getContentTypeList() {
        return this.contentTypeList;
    }

    public void setContentTypeList(Map<String, String> contentTypeList) {
        this.contentTypeList = contentTypeList;
    }

    public RequestMatcher getRequireCsrfInjectTokenMatcher() {
        return this.requireCsrfInjectTokenMatcher;
    }

    public void setRequireCsrfInjectTokenMatcher(RequestMatcher requireCsrfInjectTokenMatcher) {
        this.requireCsrfInjectTokenMatcher = requireCsrfInjectTokenMatcher;
    }

    public String getDomains() {
        return this.domains;
    }

    public void setDomains(String domains) {
        this.domains = domains;
        AntiCsrfUtils.setDomains(this.domains);
    }

    private long writeScriptToResponse(HttpServletRequest request, HttpServletResponse response, ScripInjectResponseWrapper responseWrapper) throws IOException {
        if (this.scriptTemplate.length() == 0) {
            this.scriptTemplate = FileLoadUtil.loadFileFromClassPath(TEMP_FILE_NAME);
        }
        String script = "<script>" + AntiCsrfUtils.generateAntiCsrfScript(request, this.scriptTemplate) + "</script>";
        long scriptLen = script.length();
        if (responseWrapper.isUseWriter()) {
            responseWrapper.getWriter().write(script);
        } else {
            String encode = "UTF-8";
            if (response.getCharacterEncoding() != null) {
                encode = response.getCharacterEncoding();
            }
            responseWrapper.getOutputStream().write(script.getBytes(encode));
        }
        return scriptLen;
    }

    private boolean contentTypeMatch(String contentType) {
        boolean match = false;
        if (contentType != null) {
            String[] contentTypes = contentType.split(";");
            if (this.contentTypeList != null && this.contentTypeList.containsKey(contentTypes[0].trim())) {
                match = true;
            }
        }
        return match;
    }
}

