/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import com.huawei.springframework.security.web.csrf.Cache;
import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;

public class CsrfPathRequestMatcher
implements RequestMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(CsrfPathRequestMatcher.class);
    private Map<String, Pattern> cachedUrlPatterns = new LinkedHashMap<String, Pattern>();
    private Cache<String, Map<String, Boolean>> cachedUrls = new Cache(100, 10, 10240);
    private ReentrantLock lock = new ReentrantLock();
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private boolean urlNormalizeEnable = false;

    public CsrfPathRequestMatcher(Map<String, String> notCheckCsrfList) {
        this.constructCsrfPathMatcher(notCheckCsrfList);
    }

    public CsrfPathRequestMatcher(Map<String, String> notCheckCsrfList, boolean urlNormalizeEnable) {
        this.urlNormalizeEnable = urlNormalizeEnable;
        this.constructCsrfPathMatcher(notCheckCsrfList);
    }

    private void constructCsrfPathMatcher(Map<String, String> notCheckCsrfList) {
        if (notCheckCsrfList == null) {
            throw new IllegalArgumentException("The CSRF not check list is null.");
        }
        for (Map.Entry<String, String> key : notCheckCsrfList.entrySet()) {
            this.cachedUrlPatterns.put(key.getKey(), Pattern.compile(key.getValue(), 2));
        }
        this.pathMatcher.setTrimTokens(false);
    }

    public void addWhiteUrl(String url, String method) {
        this.cachedUrlPatterns.put(url, Pattern.compile(method));
    }

    public boolean isCachedMatchs(HttpServletRequest request) {
        String excludeContextPath = RequestUtils.getNormalizeRequestServletURI(request);
        return this.cachedUrls.get(excludeContextPath) != null && this.cachedUrls.get(excludeContextPath).get(request.getMethod()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(HttpServletRequest request) {
        if (EmptyUtils.isEmpty(this.cachedUrlPatterns)) {
            return true;
        }
        String excludeContextPath = RequestUtils.getNormalizeRequestServletURI(request, this.urlNormalizeEnable);
        Map<String, Boolean> csrfMap = this.cachedUrls.get(excludeContextPath);
        Boolean isCsrf = null;
        if (csrfMap == null || (isCsrf = csrfMap.get(request.getMethod())) == null) {
            for (Map.Entry<String, Pattern> entry : this.cachedUrlPatterns.entrySet()) {
                if (!this.pathMatcher.match(entry.getKey(), RequestUtils.getNormalizeRequestServletURI(request, this.urlNormalizeEnable))) continue;
                isCsrf = !entry.getValue().matcher(request.getMethod()).matches();
                break;
            }
            isCsrf = isCsrf == null ? Boolean.TRUE : isCsrf;
            this.lock.lock();
            try {
                if (csrfMap == null) {
                    csrfMap = new HashMap<String, Boolean>(10);
                }
                csrfMap.put(request.getMethod(), isCsrf);
                try {
                    this.cachedUrls.put(excludeContextPath, csrfMap);
                }
                catch (Cache.OutOfLimitException e) {
                    LOG.error("[WSF-Cache] Failed to store request match result. {}", (Object)e.getMessage());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return isCsrf;
    }
}

