/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import com.huawei.springframework.security.web.csrf.AntiCsrfUtils;
import com.huawei.springframework.security.web.csrf.TokenSecureRandom;
import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.RequestUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;

public class HttpSessionCsrfTokenRepository
implements CsrfTokenRepository {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessionCsrfTokenRepository.class);
    private static final String DEFAULT_HEADER_NAME = "X-CSRF-TOKEN";
    private static final String DEFAULT_PARAMETER_NAME = "_csrf";
    private static final String DEFAULT_TOKEN_ATTR_NAME = HttpSessionCsrfTokenRepository.class.getName().concat(".CSRF_TOKEN");
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private static final char DOMAIN_QUOTATION_MARKS = '\"';
    private String headerName = "X-CSRF-TOKEN";
    private String parameterName = "_csrf";
    private boolean saveOnceToken = false;
    private String sessionAttrName = DEFAULT_TOKEN_ATTR_NAME;
    private String csrfDomain = null;

    private String createDomainList(HttpServletRequest request) {
        StringBuilder domainsBuffer = new StringBuilder();
        String domains = AntiCsrfUtils.getDomains();
        if (EmptyUtils.hasText(domains)) {
            domainsBuffer.append(domains);
        }
        if (EmptyUtils.hasText(this.csrfDomain)) {
            domainsBuffer.append('\"');
            domainsBuffer.append(this.csrfDomain.replace(",", "\",\""));
            domainsBuffer.append('\"');
            domainsBuffer.append(',');
        }
        domainsBuffer.append('\"').append(RequestUtils.getLocalDomain(request)).append('\"');
        return domainsBuffer.toString();
    }

    public CsrfToken generateToken(HttpServletRequest req) {
        return new DefaultCsrfToken(this.headerName, this.parameterName, TokenSecureRandom.getInstance().createNewToken());
    }

    public String getCsrfDomain() {
        return this.csrfDomain;
    }

    public void setCsrfDomain(String csrfDomain) {
        this.csrfDomain = csrfDomain;
    }

    public boolean isSaveOnceToken() {
        return this.saveOnceToken;
    }

    public void setSaveOnceToken(boolean saveOnceToken) {
        this.saveOnceToken = saveOnceToken;
    }

    public CsrfToken loadToken(HttpServletRequest request) {
        CsrfToken csrfToken = null;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return csrfToken;
        }
        Object attribute = session.getAttribute(this.sessionAttrName);
        if (attribute instanceof CsrfToken) {
            csrfToken = (CsrfToken)attribute;
        }
        return csrfToken;
    }

    public void saveToken(CsrfToken csrfToken, HttpServletRequest request, HttpServletResponse resp) {
        if (csrfToken == null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(this.sessionAttrName);
                if (!this.saveOnceToken) {
                    session.removeAttribute("csrf_header");
                    session.removeAttribute("csrf_param");
                    session.removeAttribute("csrf_token");
                    session.removeAttribute("csrf_domain");
                }
            }
        } else {
            HttpSession session = request.getSession(true);
            session.setAttribute(this.sessionAttrName, (Object)csrfToken);
            if (!this.saveOnceToken) {
                session.setAttribute("csrf_header", (Object)csrfToken.getHeaderName());
                session.setAttribute("csrf_param", (Object)csrfToken.getParameterName());
                session.setAttribute("csrf_token", (Object)csrfToken.getToken());
                session.setAttribute("csrf_domain", (Object)this.createDomainList(request));
            }
        }
    }

    public void setHeaderName(String headerName) {
        if (headerName != null) {
            this.headerName = headerName;
        }
    }

    public void setParameterName(String paramName) {
        if (paramName != null) {
            this.parameterName = paramName;
        }
    }

    public void setSessionAttributeName(String attributeName) {
        if (attributeName != null) {
            this.sessionAttrName = attributeName;
        }
    }
}

