/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import com.huawei.springframework.security.web.csrf.ScriptInjectOutputStream;
import com.huawei.springframework.security.web.csrf.ScriptInjectPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class ScripInjectResponseWrapper
extends HttpServletResponseWrapper {
    private static final String CONTENT_LENGTH = "Content-Length";
    private long contentLen = 0L;
    private boolean setContentLen = false;
    private ScriptInjectOutputStream stream = null;
    private boolean useWriter = false;
    private ScriptInjectPrintWriter writer = null;

    ScripInjectResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void addHeader(String name, String value) {
        if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
            this.contentLen = Long.parseLong(value);
            this.setContentLen = true;
        } else {
            super.addHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
            this.contentLen = value;
            this.setContentLen = true;
        } else {
            super.addIntHeader(name, value);
        }
    }

    public long getContentLength() {
        return this.contentLen;
    }

    public void setContentLength(int length) {
        this.contentLen = length;
        this.setContentLen = true;
    }

    public ScriptInjectOutputStream getOutputStream() throws IOException {
        this.useWriter = false;
        if (this.stream == null) {
            this.stream = new ScriptInjectOutputStream(super.getOutputStream());
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        this.useWriter = true;
        if (this.writer == null) {
            this.writer = new ScriptInjectPrintWriter(super.getWriter());
        }
        return this.writer;
    }

    public boolean isSetContentLength() {
        return this.setContentLen;
    }

    public boolean isUseWriter() {
        return this.useWriter;
    }

    public void setUseWriter(boolean useWriter) {
        this.useWriter = useWriter;
    }

    public void setContentLengthLong(long length) {
        this.contentLen = length;
        this.setContentLen = true;
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
            this.contentLen = Long.parseLong(value);
            this.setContentLen = true;
        } else {
            super.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
            this.contentLen = value;
            this.setContentLen = true;
        } else {
            super.setIntHeader(name, value);
        }
    }
}

