/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.csrf;

import com.huawei.springframework.security.web.csrf.BcRandomBuild;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSecureRandom {
    private static final Logger LOG = LoggerFactory.getLogger(TokenSecureRandom.class);
    private static volatile TokenSecureRandom singletonInstance;
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private SecureRandom secureRandom;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initInstance(String randomGenerator) {
        if (singletonInstance != null) return;
        Class<TokenSecureRandom> clazz = TokenSecureRandom.class;
        synchronized (TokenSecureRandom.class) {
            if (singletonInstance != null) return;
            singletonInstance = new TokenSecureRandom(randomGenerator);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static TokenSecureRandom getInstance() {
        return singletonInstance;
    }

    public TokenSecureRandom(String randomGenerator) {
        try {
            if ("SHA1Random".equals(randomGenerator)) {
                this.secureRandom = SecureRandom.getInstance(RANDOM_ALGORITHM);
            } else if ("BcStrongRandom".equals(randomGenerator)) {
                BcRandomBuild bcRandomBuild = new BcRandomBuild();
                this.secureRandom = bcRandomBuild.buildBcSecureRandom();
            } else {
                this.secureRandom = SecureRandom.getInstanceStrong();
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("[WSF-Core] Fail to creat csrf token, please check random algorithm.");
        }
    }

    public String createNewToken() {
        byte[] rbs = new byte[24];
        StringBuilder token = new StringBuilder(24);
        this.secureRandom.nextBytes(rbs);
        for (byte rb : rbs) {
            String strTemp = Integer.toHexString(0xFF & rb);
            if (strTemp.length() < 2) {
                token.append(0);
            }
            token.append(strTemp.toUpperCase(Locale.US));
        }
        return token.toString();
    }
}

