/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.dos;

import com.huawei.springframework.security.web.access.DosAccessDeniedHandler;
import com.huawei.springframework.security.web.access.DosAccessDeniedHandlerImpl;
import com.huawei.springframework.security.web.dos.DosConfig;
import com.huawei.springframework.security.web.dos.DosStatisticsException;
import com.huawei.springframework.security.web.dos.DosStatisticsProcess;
import com.huawei.springframework.security.web.dos.DosStatisticsRepository;
import com.huawei.springframework.security.web.dos.HttpSessoionDosStatisticsRepository;
import com.huawei.springframework.security.web.dos.IPDosStatisticsRepository;
import com.huawei.springframework.security.web.util.CoreConstant;
import com.huawei.springframework.security.web.util.EmptyUtils;
import com.huawei.springframework.security.web.util.IPFormatCheckUtil;
import com.huawei.springframework.security.web.util.OmSwitch;
import com.huawei.springframework.security.web.util.RequestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DosPrecautionFilter
implements Filter {
    protected static final String ACCESS_DENIED_HANDLER = "access_denied_handler";
    protected static final String HIT_FILTER_CONFIG = "hits";
    protected static final String PERIOD_FILTER_CONFIG = "period";
    protected static final String REPOSITORY_FILTER_CONFIG = "repository";
    private static final Logger LOG = LoggerFactory.getLogger(DosPrecautionFilter.class);
    private DosAccessDeniedHandler accessDeniedHandler = new DosAccessDeniedHandlerImpl();
    private DosStatisticsProcess process = null;
    private String omPropertyFilePath = "";
    private OmSwitch instance;
    private final List<String> ipGatewayList = new ArrayList<String>();
    private final List<String> ipWhiteList = new ArrayList<String>();
    private final List<String> headerValues = new ArrayList<String>();
    private int clearTime = 1800000;
    private int maxSize = 10000;
    private int period = 10000;
    private Boolean ipControl = false;

    public void destroy() {
        this.process = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.skipInstance(request, response, filterChain)) {
            return;
        }
        HttpServletRequest httpRequest = RequestUtils.requestDowncast(request);
        HttpServletResponse httpResponse = RequestUtils.responseDowncast(response);
        try {
            this.process.doStatistics(httpRequest);
            filterChain.doFilter(request, response);
        }
        catch (DosStatisticsException e) {
            this.accessDeniedHandler.handle(httpRequest, httpResponse, e);
        }
    }

    private boolean skipInstance(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.instance != null) {
            String closeSwitch;
            String dynamicSwitch = this.instance.getProperty("dynamicSwitch");
            if ("true".equalsIgnoreCase(dynamicSwitch)) {
                this.initOmFunction();
            }
            if ("OFF".equalsIgnoreCase(closeSwitch = this.instance.getProperty("DosPrecautionFilter"))) {
                LOG.warn("[WSF-DosPrecautionFilter] OM Scenario DosPrecautionFilter is skipping.");
                filterChain.doFilter(request, response);
                return true;
            }
        }
        return false;
    }

    public void initOmFunction() {
        this.instance = OmSwitch.updateSwitch(this.omPropertyFilePath);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.omPropertyFilePath = filterConfig.getInitParameter("propertyFilePath");
        DosConfig config = new DosConfig();
        config.setHits(filterConfig.getInitParameter(HIT_FILTER_CONFIG));
        String periodStr = filterConfig.getInitParameter(PERIOD_FILTER_CONFIG);
        config.setPeriod(periodStr);
        this.period = DosPrecautionFilter.formatPeriod(periodStr);
        this.initOmFunction();
        String repository = filterConfig.getInitParameter(REPOSITORY_FILTER_CONFIG);
        this.processAccessControlConfig(filterConfig);
        DosStatisticsRepository dosStatisticsRepository = this.ipControl != false ? new IPDosStatisticsRepository(this.ipGatewayList, this.ipWhiteList, this.headerValues, this.clearTime, this.maxSize) : (EmptyUtils.hasText(repository) ? this.creatRepositoryInstance(repository) : new HttpSessoionDosStatisticsRepository());
        this.process = new DosStatisticsProcess(dosStatisticsRepository, config);
        String handler = filterConfig.getInitParameter(ACCESS_DENIED_HANDLER);
        if (EmptyUtils.hasText(handler)) {
            this.accessDeniedHandler = this.createHandlerInstance(handler);
        }
    }

    private void processAccessControlConfig(FilterConfig filterConfig) {
        String ipControlStr = filterConfig.getInitParameter("ip_based_access_control");
        if ("true".equalsIgnoreCase(ipControlStr)) {
            this.ipControl = true;
            String ipGateWayListStr = filterConfig.getInitParameter("ip_gateway_list");
            String ipWhiteListStr = filterConfig.getInitParameter("ip_white_list");
            String headerValueStr = filterConfig.getInitParameter("header_values");
            IPFormatCheckUtil.processParamResult(!IPFormatCheckUtil.isLegalParams(headerValueStr, CoreConstant.HEADER_LIST_PATTERN));
            IPFormatCheckUtil.fillList(ipGateWayListStr, this.ipGatewayList);
            IPFormatCheckUtil.fillList(ipWhiteListStr, this.ipWhiteList);
            IPFormatCheckUtil.fillList(headerValueStr, this.headerValues);
            IPFormatCheckUtil.checkIpRange(this.ipWhiteList);
            IPFormatCheckUtil.checkIpRange(this.ipGatewayList);
            String clearTimeStr = filterConfig.getInitParameter("clear_time");
            String maxSizeStr = filterConfig.getInitParameter("max_size");
            this.clearTime = IPFormatCheckUtil.formatNumber(clearTimeStr, "clear_time", 1800) * 1000;
            this.maxSize = IPFormatCheckUtil.formatNumber(maxSizeStr, "max_size", this.maxSize);
            if (this.clearTime < this.period || this.clearTime % this.period != 0) {
                throw new IllegalArgumentException("[WSF-Core] Illegal input param clearTime or period.");
            }
            LOG.info("[WSF-Core] Ip based access control is on.");
        }
    }

    private DosStatisticsRepository creatRepositoryInstance(String value) throws ServletException {
        try {
            Object repositoryInstance = Class.forName(value).newInstance();
            if (repositoryInstance instanceof DosStatisticsRepository) {
                return (DosStatisticsRepository)repositoryInstance;
            }
            throw new ServletException("Reflect DosStatisticsRepository failed.");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ServletException("Reflect DosStatisticsRepository failed! " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static int formatPeriod(String period) {
        try {
            int result = Integer.parseInt(period);
            if (result > 0) {
                return result * 1000;
            }
            return 10000;
        }
        catch (NumberFormatException ex) {
            LOG.warn("[WSF-Core] The parameter Period config error period use default.");
            return 10000;
        }
    }

    private DosAccessDeniedHandler createHandlerInstance(String handler) throws ServletException {
        try {
            Object handlerInstance = Class.forName(handler).newInstance();
            if (handlerInstance instanceof DosAccessDeniedHandler) {
                return (DosAccessDeniedHandler)handlerInstance;
            }
            throw new ServletException("Reflect DosAccessDeniedHandler failed.");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ServletException("Reflect DosAccessDeniedHandler failed! " + ex.getMessage(), (Throwable)ex);
        }
    }
}

