/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.springframework.security.web.dos;

import com.huawei.springframework.security.web.dos.DosConfig;
import com.huawei.springframework.security.web.dos.DosStatisticsException;
import com.huawei.springframework.security.web.dos.DosStatisticsRepository;
import com.huawei.springframework.security.web.dos.HttpSessoionDosStatisticsRepository;
import com.huawei.springframework.security.web.dos.TokenBucket;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DosStatisticsProcess {
    private static final Logger LOG = LoggerFactory.getLogger(DosStatisticsProcess.class);
    private DosConfig config = null;
    private DosStatisticsRepository repository = new HttpSessoionDosStatisticsRepository();

    public DosStatisticsProcess(DosStatisticsRepository repository, DosConfig config) {
        this.repository = repository;
        this.config = config;
    }

    public void doStatistics(HttpServletRequest request) throws DosStatisticsException {
        TokenBucket bucket = this.repository.getStatistics(request, this.config);
        if (bucket.judgeInWhiteIpList()) {
            LOG.debug("[WSF-Core] Request Ip in white list.");
        } else {
            if (bucket.judgeIllegalIpList()) {
                throw new DosStatisticsException("Request Ip illegal.");
            }
            if (!bucket.hasToken()) {
                throw new DosStatisticsException("Request rate too high.");
            }
        }
    }
}

